/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;

public final class EEModuleClassDescription {
    private final String className;
    private boolean invalid;
    private StringBuilder invalidMessageBuilder;
    private final Map<Class<? extends Annotation>, ClassAnnotationInformation<?, ?>> annotationInformation = Collections.synchronizedMap(new HashMap());
    private InterceptorClassDescription interceptorClassDescription = InterceptorClassDescription.EMPTY_INSTANCE;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Map<InjectionTarget, ResourceInjectionConfiguration> injectionConfigurations = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();

    public EEModuleClassDescription(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public InterceptorClassDescription getInterceptorClassDescription() {
        return this.interceptorClassDescription;
    }

    public void setInterceptorClassDescription(InterceptorClassDescription interceptorClassDescription) {
        if (interceptorClassDescription == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("interceptorClassDescription", "module class", this.className);
        }
        this.interceptorClassDescription = interceptorClassDescription;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Map<InjectionTarget, ResourceInjectionConfiguration> getInjectionConfigurations() {
        return this.injectionConfigurations;
    }

    public void addResourceInjection(ResourceInjectionConfiguration injection) {
        this.injectionConfigurations.put(injection.getTarget(), injection);
    }

    public void addAnnotationInformation(ClassAnnotationInformation annotationInformation) {
        this.annotationInformation.put(annotationInformation.getAnnotationType(), annotationInformation);
    }

    public <A extends Annotation, T> ClassAnnotationInformation<A, T> getAnnotationInformation(Class<A> annotationType) {
        return this.annotationInformation.get(annotationType);
    }

    public synchronized void setInvalid(String message) {
        if (!this.invalid) {
            this.invalid = true;
            this.invalidMessageBuilder = new StringBuilder();
        } else {
            this.invalidMessageBuilder.append('\n');
        }
        this.invalidMessageBuilder.append(message);
    }

    public synchronized boolean isInvalid() {
        return this.invalid;
    }

    public String getInvalidMessage() {
        if (this.invalidMessageBuilder == null) {
            return "";
        }
        return this.invalidMessageBuilder.toString();
    }
}

