/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class EEStartupCountdownProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        int startupBeansCount = moduleDescription.getStartupBeansCount();
        if (deploymentUnit.getParent() == null) {
            deploymentUnit.putAttachment(Attachments.STARTUP_COUNTDOWN, (Object)new StartupCountdown(startupBeansCount));
        } else {
            StartupCountdown countdown = (StartupCountdown)deploymentUnit.getParent().getAttachment(Attachments.STARTUP_COUNTDOWN);
            deploymentUnit.putAttachment(Attachments.STARTUP_COUNTDOWN, (Object)countdown);
            countdown.countUp(startupBeansCount);
        }
    }
}

