/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;
import org.jboss.dmr.stream.ModelGrammarAnalyzer;
import org.jboss.dmr.stream.ModelWriter;
import org.jboss.dmr.stream.Utils;

final class ModelWriterImpl
implements ModelWriter {
    private static final String BIG_DECIMAL_PREFIX = "big decimal ";
    private static final String BIG_INTEGER_PREFIX = "big integer ";
    private static final String BYTES_PREFIX = "bytes {";
    private static final String BYTES_SUFFIX = "}";
    private static final String EXPRESSION_PREFIX = "expression ";
    private final ModelGrammarAnalyzer analyzer;
    private final Writer out;
    private final char[] buffer = new char[1024];
    private int limit;
    private boolean closed;

    ModelWriterImpl(Writer out) {
        this.out = out;
        this.analyzer = new ModelGrammarAnalyzer();
    }

    @Override
    public void close() throws IOException, ModelException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        if (!this.analyzer.finished) {
            throw this.analyzer.newModelException("Uncomplete DMR stream have been written");
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.limit > 0) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.out.flush();
    }

    @Override
    public ModelWriterImpl writeObjectStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putObjectStart();
        this.write('{');
        return this;
    }

    @Override
    public ModelWriterImpl writeObjectEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putObjectEnd();
        this.write('}');
        return this;
    }

    @Override
    public ModelWriterImpl writePropertyStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putPropertyStart();
        this.write('(');
        return this;
    }

    @Override
    public ModelWriterImpl writePropertyEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putPropertyEnd();
        this.write(')');
        return this;
    }

    @Override
    public ModelWriterImpl writeListStart() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putListStart();
        this.write('[');
        return this;
    }

    @Override
    public ModelWriterImpl writeListEnd() throws IOException, ModelException {
        this.ensureOpen();
        this.analyzer.putListEnd();
        this.write(']');
        return this;
    }

    @Override
    public ModelWriterImpl writeExpression(String data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putExpression();
        this.write(EXPRESSION_PREFIX);
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriterImpl writeString(String data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putString();
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriterImpl writeBytes(byte[] data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putBytes();
        this.write(BYTES_PREFIX);
        this.encode(data);
        this.write(BYTES_SUFFIX);
        return this;
    }

    @Override
    public ModelWriterImpl writeUndefined() throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putUndefined();
        this.write("undefined");
        return this;
    }

    @Override
    public ModelWriterImpl writeBoolean(boolean data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putBoolean();
        if (data) {
            this.write("true");
        } else {
            this.write("false");
        }
        return this;
    }

    @Override
    public ModelWriterImpl writeInt(int data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putNumber(ModelEvent.INT);
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriterImpl writeLong(long data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putNumber(ModelEvent.LONG);
        this.encode(data);
        return this;
    }

    @Override
    public ModelWriterImpl writeDouble(double data) throws IOException, ModelException {
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putNumber(ModelEvent.DOUBLE);
        this.write(String.valueOf(data));
        return this;
    }

    @Override
    public ModelWriterImpl writeBigInteger(BigInteger data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putNumber(ModelEvent.BIG_INTEGER);
        this.write(BIG_INTEGER_PREFIX);
        this.write(String.valueOf(data));
        return this;
    }

    @Override
    public ModelWriterImpl writeBigDecimal(BigDecimal data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter(data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putNumber(ModelEvent.BIG_DECIMAL);
        this.write(BIG_DECIMAL_PREFIX);
        this.write(String.valueOf(data));
        return this;
    }

    @Override
    public ModelWriterImpl writeType(ModelType data) throws IOException, ModelException {
        ModelWriterImpl.assertNotNullParameter((Object)data);
        this.ensureOpen();
        this.writeOptionalArrowOrComma();
        this.analyzer.putType();
        this.write(data.toString());
        return this;
    }

    private void writeOptionalArrowOrComma() throws IOException, ModelException {
        if (this.analyzer.isArrowExpected()) {
            this.analyzer.putArrow();
            this.write("=>");
        } else if (this.analyzer.isCommaExpected()) {
            this.analyzer.putComma();
            this.write(',');
        }
    }

    private void write(char c) throws IOException {
        if (this.limit == this.buffer.length) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.buffer[this.limit++] = c;
    }

    private void write(String data, int dataBegin, int dataEnd) throws IOException {
        while (dataBegin < dataEnd) {
            int count = Math.min(dataEnd - dataBegin, this.buffer.length - this.limit);
            data.getChars(dataBegin, dataBegin + count, this.buffer, this.limit);
            dataBegin += count;
            this.limit += count;
            if (this.limit != this.buffer.length) continue;
            this.out.write(this.buffer, 0, this.buffer.length);
            this.limit = 0;
        }
    }

    private void write(String data) throws IOException {
        this.write(data, 0, data.length());
    }

    private void encode(byte[] data) throws IOException {
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            byte b = data[i];
            if (b >= 0 && b < 16) {
                this.write("0x0");
                this.write(Integer.toHexString(b & 0xFF));
            } else {
                this.write("0x");
                this.write(Integer.toHexString(b & 0xFF));
            }
            if (i == length - 1) continue;
            this.write(',');
        }
    }

    private void encode(String s) throws IOException {
        this.write('\"');
        int dataBegin = 0;
        for (int dataEnd = 0; dataEnd < s.length(); ++dataEnd) {
            char c = s.charAt(dataEnd);
            while (c != '\\' && c != '\"' && ++dataEnd < s.length()) {
                c = s.charAt(dataEnd);
            }
            if (dataBegin < dataEnd) {
                this.write(s, dataBegin, dataEnd);
                if (dataEnd == s.length()) break;
            }
            dataBegin = dataEnd + 1;
            this.write('\\');
            this.write(c);
        }
        this.write('\"');
    }

    private void encode(long l) throws IOException {
        int intQuotient;
        int remainder;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 20) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(l) + 1;
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        this.buffer[--writeIndex] = 76;
        while (l < Integer.MIN_VALUE) {
            long longQuotient = l / 100L;
            remainder = (int)(longQuotient * 100L - l);
            l = longQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        int i = (int)l;
        while (i <= -100) {
            intQuotient = i / 100;
            remainder = intQuotient * 100 - i;
            i = intQuotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        intQuotient = i / 10;
        remainder = intQuotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (intQuotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - intQuotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void encode(int i) throws IOException {
        int remainder;
        int quotient;
        boolean negative;
        int writeIndex;
        if (this.buffer.length - this.limit < 11) {
            this.out.write(this.buffer, 0, this.limit);
            this.limit = 0;
        }
        this.limit = writeIndex = this.limit + Utils.stringSizeOf(i);
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            quotient = i / 100;
            remainder = quotient * 100 - i;
            i = quotient;
            this.buffer[--writeIndex] = Utils.ONES[remainder];
            this.buffer[--writeIndex] = Utils.TENS[remainder];
        }
        quotient = i / 10;
        remainder = quotient * 10 - i;
        this.buffer[--writeIndex] = (char)(48 + remainder);
        if (quotient < 0) {
            this.buffer[--writeIndex] = (char)(48 - quotient);
        }
        if (negative) {
            this.buffer[--writeIndex] = 45;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("DMR writer have been closed");
        }
    }

    private static void assertNotNullParameter(Object o) {
        if (o == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
    }
}

