/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.AbstractQueueControlHandler;
import org.wildfly.extension.messaging.activemq.OperationDefinitionHelper;
import org.wildfly.extension.messaging.activemq.QueueDefinition;

public class QueueControlHandler
extends AbstractQueueControlHandler<QueueControl> {
    public static final QueueControlHandler INSTANCE = new QueueControlHandler();
    private static final AttributeDefinition MESSAGE_ID = SimpleAttributeDefinitionBuilder.create((String)"message-id", (ModelType)ModelType.LONG).build();

    private QueueControlHandler() {
    }

    @Override
    protected AttributeDefinition getMessageIDAttributeDefinition() {
        return MESSAGE_ID;
    }

    @Override
    protected AttributeDefinition[] getReplyMessageParameterDefinitions() {
        return new AttributeDefinition[]{OperationDefinitionHelper.createNonEmptyStringAttribute("messageID"), OperationDefinitionHelper.createNonEmptyStringAttribute("userID"), OperationDefinitionHelper.createNonEmptyStringAttribute("address"), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.INT).setValidator((ParameterValidator)new TypeValidator())).build(), SimpleAttributeDefinitionBuilder.create((String)"durable", (ModelType)ModelType.INT).build(), SimpleAttributeDefinitionBuilder.create((String)"expiration", (ModelType)ModelType.LONG).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"priority", (ModelType)ModelType.INT).setValidator(PRIORITY_VALIDATOR)).build()};
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    @Override
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!QueueDefinition.forwardToRuntimeQueue(context, operation, (OperationStepHandler)INSTANCE)) {
            super.executeRuntimeStep(context, operation);
        }
    }

    @Override
    protected Object handleAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl) throws OperationFailedException {
        this.throwUnimplementedOperationException(operationName);
        return null;
    }

    @Override
    protected void revertAdditionalOperation(String operationName, ModelNode operation, OperationContext context, QueueControl queueControl, Object handback) {
    }

    @Override
    protected AbstractQueueControlHandler.DelegatingQueueControl<QueueControl> getQueueControl(ActiveMQServer server, String queueName) {
        final QueueControl control = (QueueControl)QueueControl.class.cast(server.getManagementService().getResource("queue." + queueName));
        if (control == null) {
            return null;
        }
        return new AbstractQueueControlHandler.DelegatingQueueControl<QueueControl>(){

            @Override
            public QueueControl getDelegate() {
                return control;
            }

            @Override
            public String listMessagesAsJSON(String filter) throws Exception {
                return control.listMessagesAsJSON(filter);
            }

            @Override
            public long countMessages(String filter) throws Exception {
                return control.countMessages(filter);
            }

            @Override
            public boolean removeMessage(ModelNode id) throws Exception {
                return control.removeMessage(id.asLong());
            }

            @Override
            public int removeMessages(String filter) throws Exception {
                return control.removeMessages(filter);
            }

            @Override
            public int expireMessages(String filter) throws Exception {
                return control.expireMessages(filter);
            }

            @Override
            public boolean expireMessage(ModelNode id) throws Exception {
                return control.expireMessage(id.asLong());
            }

            @Override
            public boolean sendMessageToDeadLetterAddress(ModelNode id) throws Exception {
                return control.sendMessageToDeadLetterAddress(id.asLong());
            }

            @Override
            public int sendMessagesToDeadLetterAddress(String filter) throws Exception {
                return control.sendMessagesToDeadLetterAddress(filter);
            }

            @Override
            public boolean changeMessagePriority(ModelNode id, int priority) throws Exception {
                return control.changeMessagePriority(id.asLong(), priority);
            }

            @Override
            public int changeMessagesPriority(String filter, int priority) throws Exception {
                return control.changeMessagesPriority(filter, priority);
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue) throws Exception {
                return control.moveMessage(id.asLong(), otherQueue);
            }

            @Override
            public boolean moveMessage(ModelNode id, String otherQueue, boolean rejectDuplicates) throws Exception {
                return control.moveMessage(id.asLong(), otherQueue, rejectDuplicates);
            }

            @Override
            public int moveMessages(String filter, String otherQueue) throws Exception {
                return control.moveMessages(filter, otherQueue);
            }

            @Override
            public int moveMessages(String filter, String otherQueue, boolean rejectDuplicates) throws Exception {
                return control.moveMessages(filter, otherQueue, rejectDuplicates);
            }

            @Override
            public String listMessageCounter() throws Exception {
                return control.listMessageCounter();
            }

            @Override
            public void resetMessageCounter() throws Exception {
                control.resetMessageCounter();
            }

            @Override
            public String listMessageCounterAsHTML() throws Exception {
                return control.listMessageCounterAsHTML();
            }

            @Override
            public String listMessageCounterHistory() throws Exception {
                return control.listMessageCounterHistory();
            }

            @Override
            public String listMessageCounterHistoryAsHTML() throws Exception {
                return control.listMessageCounterHistoryAsHTML();
            }

            @Override
            public void pause() throws Exception {
                control.pause();
            }

            @Override
            public void resume() throws Exception {
                control.resume();
            }

            @Override
            public String listConsumersAsJSON() throws Exception {
                return control.listConsumersAsJSON();
            }

            @Override
            public String listScheduledMessagesAsJSON() throws Exception {
                return control.listScheduledMessagesAsJSON();
            }

            @Override
            public String listDeliveringMessagesAsJSON() throws Exception {
                return control.listDeliveringMessagesAsJSON();
            }
        };
    }

    private static class TypeValidator
    extends ModelTypeValidator
    implements AllowedValuesValidator {
        private TypeValidator() {
            super(ModelType.INT);
        }

        public List<ModelNode> getAllowedValues() {
            ArrayList<ModelNode> values = new ArrayList<ModelNode>();
            values.add(ModelNode.ZERO);
            values.add(new ModelNode(2));
            values.add(new ModelNode(3));
            values.add(new ModelNode(4));
            values.add(new ModelNode(5));
            values.add(new ModelNode(6));
            return values;
        }
    }
}

