/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.weld.WeldCapability;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;

public class JSFComponentProcessor
implements DeploymentUnitProcessor {
    public static final DotName MANAGED_BEAN_ANNOTATION = DotName.createSimple((String)"javax.faces.bean.ManagedBean");
    private static final String WEB_INF_FACES_CONFIG = "WEB-INF/faces-config.xml";
    private static final String CONFIG_FILES = "javax.faces.CONFIG_FILES";
    private static final JsfTree facesConfigElement = new JsfTree(JsfTag.FACES_CONFIG, new JsfTree(JsfTag.FACTORY, new JsfTree(JsfTag.APPLICATION_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.VISIT_CONTEXT_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.EXCEPTION_HANDLER_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.EXTERNAL_CONTEXT_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.FACES_CONTEXT_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.PARTIAL_VIEW_CONTEXT_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.LIFECYCLE_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.RENDER_KIT_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.VIEW_DECLARATION_LANGUAGE_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.FACELET_CACHE_FACTORY, new JsfTree[0]), new JsfTree(JsfTag.TAG_HANDLER_DELEGATE_FACTORY, new JsfTree[0])), new JsfTree(JsfTag.APPLICATION, new JsfTree(JsfTag.EL_RESOLVER, new JsfTree[0]), new JsfTree(JsfTag.RESOURCE_HANDLER, new JsfTree[0]), new JsfTree(JsfTag.STATE_MANAGER, new JsfTree[0]), new JsfTree(JsfTag.ACTION_LISTENER, new JsfTree[0]), new JsfTree(JsfTag.NAVIGATION_HANDLER, new JsfTree[0]), new JsfTree(JsfTag.VIEW_HANDLER, new JsfTree[0]), new JsfTree(JsfTag.SYSTEM_EVENT_LISTENER, new JsfTree(JsfTag.SYSTEM_EVENT_LISTENER_CLASS, new JsfTree[0]))), new JsfTree(JsfTag.LIFECYCLE, new JsfTree(JsfTag.PHASE_LISTENER, new JsfTree[0])), new JsfTree(JsfTag.MANAGED_BEAN, new JsfTree(JsfTag.MANAGED_BEAN_CLASS, new JsfTree[0])));

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            return;
        }
        if (index == null) {
            return;
        }
        if (module == null) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashSet<String> managedBeanClasses = new HashSet<String>();
        this.handleAnnotations(index, managedBeanClasses);
        for (String managedBean : managedBeanClasses) {
            this.installManagedBeanComponent(managedBean, moduleDescription, module, deploymentUnit, applicationClassesDescription);
        }
        this.processJSFArtifactsForInjection(deploymentUnit, managedBeanClasses);
    }

    private void processJSFArtifactsForInjection(DeploymentUnit deploymentUnit, Set<String> managedBeanClasses) {
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        boolean isCDI = support.hasCapability("org.wildfly.weld") && ((WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        JsfElement current = null;
        LinkedList<JsfElement> queue = new LinkedList<JsfElement>();
        for (VirtualFile facesConfig : this.getConfigurationFiles(deploymentUnit)) {
            try {
                InputStream is = facesConfig.openStream();
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setXMLResolver(NoopXMLResolver.create());
                    XMLStreamReader parser = inputFactory.createXMLStreamReader(is);
                    boolean finished = false;
                    block13: while (!finished) {
                        int event = parser.next();
                        switch (event) {
                            case 8: {
                                finished = true;
                                parser.close();
                                break;
                            }
                            case 1: {
                                JsfTree child;
                                String tagName = parser.getLocalName();
                                if (current == null) {
                                    if (tagName.equals(JsfTag.FACES_CONFIG.getTagName())) {
                                        current = new JsfElement(facesConfigElement);
                                        break;
                                    }
                                    current = new JsfElement(tagName);
                                    break;
                                }
                                JsfTree jsfTree = child = current.isTree() ? current.getTree().getChild(tagName) : null;
                                if (child != null && child.isLeaf()) {
                                    String className = parser.getElementText().trim();
                                    if (managedBeanClasses.contains(className)) continue block13;
                                    managedBeanClasses.add(className);
                                    if (child.getTag() == JsfTag.MANAGED_BEAN_CLASS) {
                                        this.installManagedBeanComponent(className, moduleDescription, module, deploymentUnit, applicationClassesDescription);
                                        break;
                                    }
                                    this.installJsfArtifactComponent(child.getTag().getTagName(), className, isCDI, moduleDescription, module, deploymentUnit, applicationClassesDescription);
                                    break;
                                }
                                if (child != null) {
                                    queue.push(current);
                                    current = new JsfElement(child);
                                    break;
                                }
                                queue.push(current);
                                current = new JsfElement(tagName);
                                break;
                            }
                            case 2: {
                                current = queue.isEmpty() ? null : (JsfElement)queue.pop();
                            }
                        }
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                JSFLogger.ROOT_LOGGER.managedBeansConfigParseFailed(facesConfig);
            }
        }
    }

    public Set<VirtualFile> getConfigurationFiles(DeploymentUnit deploymentUnit) {
        List contextParams;
        WebMetaData webMetaData;
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile metaInf;
            VirtualFile webInfFacesConfig = resourceRoot.getRoot().getChild(WEB_INF_FACES_CONFIG);
            if (webInfFacesConfig.exists()) {
                ret.add(webInfFacesConfig);
            }
            if (!(metaInf = resourceRoot.getRoot().getChild("META-INF")).exists() || !metaInf.isDirectory()) continue;
            for (VirtualFile file : metaInf.getChildren()) {
                if (!file.getName().equals("faces-config.xml") && !file.getName().endsWith(".faces-config.xml")) continue;
                ret.add(file);
            }
        }
        String configFiles = null;
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null && (webMetaData = warMetaData.getWebMetaData()) != null && (contextParams = webMetaData.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (!param.getParamName().equals(CONFIG_FILES)) continue;
                configFiles = param.getParamValue();
                break;
            }
        }
        if (configFiles != null) {
            String[] files = configFiles.split(",");
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
            if (deploymentRoot != null) {
                for (String file : files) {
                    VirtualFile configFile;
                    if (file.isEmpty() || !(configFile = deploymentRoot.getRoot().getChild(file)).exists()) continue;
                    ret.add(configFile);
                }
            }
        }
        return ret;
    }

    private void handleAnnotations(CompositeIndex index, Set<String> managedBeanClasses) throws DeploymentUnitProcessingException {
        List annotations = index.getAnnotations(MANAGED_BEAN_ANNOTATION);
        if (annotations != null) {
            for (AnnotationInstance annotation : annotations) {
                AnnotationTarget target = annotation.target();
                if (target instanceof ClassInfo) {
                    String className = ((ClassInfo)target).name().toString();
                    managedBeanClasses.add(className);
                    continue;
                }
                throw new DeploymentUnitProcessingException(JSFLogger.ROOT_LOGGER.invalidManagedBeanAnnotation(target));
            }
        }
    }

    private void installManagedBeanComponent(String className, EEModuleDescription moduleDescription, Module module, DeploymentUnit deploymentUnit, EEApplicationClasses applicationClassesDescription) {
        try {
            Class componentClass = module.getClassLoader().loadClass(className);
            componentClass.getConstructor(new Class[0]);
        }
        catch (ClassNotFoundException e) {
            JSFLogger.ROOT_LOGGER.managedBeanLoadFail(className);
            return;
        }
        catch (NoSuchMethodException e) {
            JSFLogger.ROOT_LOGGER.managedBeanNoDefaultConstructor(className);
            return;
        }
        this.install(JsfTag.MANAGED_BEAN.getTagName(), className, moduleDescription, module, deploymentUnit, applicationClassesDescription);
    }

    private void installJsfArtifactComponent(String type, String className, boolean isCDI, EEModuleDescription moduleDescription, Module module, DeploymentUnit deploymentUnit, EEApplicationClasses applicationClassesDescription) {
        try {
            Class componentClass = module.getClassLoader().loadClass(className);
            if (!isCDI) {
                componentClass.getConstructor(new Class[0]);
            }
        }
        catch (ClassNotFoundException e) {
            JSFLogger.ROOT_LOGGER.managedBeanLoadFail(className);
            return;
        }
        catch (NoSuchMethodException e) {
            JSFLogger.ROOT_LOGGER.jsfArtifactNoDefaultConstructor(type, className);
            return;
        }
        this.install(type, className, moduleDescription, module, deploymentUnit, applicationClassesDescription);
    }

    private void install(String type, String className, EEModuleDescription moduleDescription, Module module, DeploymentUnit deploymentUnit, EEApplicationClasses applicationClassesDescription) {
        WebComponentDescription componentDescription = new WebComponentDescription(type + "." + className, className, moduleDescription, deploymentUnit.getServiceName(), applicationClassesDescription);
        moduleDescription.addComponent((ComponentDescription)componentDescription);
        deploymentUnit.addToAttachmentList(WebComponentDescription.WEB_COMPONENTS, (Object)componentDescription.getStartServiceName());
    }

    private static class JsfElement {
        private final JsfTree tree;
        private final String tag;

        public JsfElement(JsfTree tree) {
            this.tree = tree;
            this.tag = null;
        }

        public JsfElement(String tag) {
            this.tree = null;
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }

        public JsfTree getTree() {
            return this.tree;
        }

        public boolean isTree() {
            return this.tree != null;
        }
    }

    private static class JsfTree {
        private final JsfTag tag;
        private final Map<String, JsfTree> children;

        public JsfTree(JsfTag tag, JsfTree ... children) {
            this.tag = tag;
            this.children = new HashMap<String, JsfTree>();
            for (JsfTree c : children) {
                this.children.put(c.getTag().getTagName(), c);
            }
        }

        public JsfTag getTag() {
            return this.tag;
        }

        public JsfTree getChild(String name) {
            return this.children.get(name);
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }
    }

    private static enum JsfTag {
        FACES_CONFIG,
        FACTORY,
        APPLICATION_FACTORY,
        VISIT_CONTEXT_FACTORY,
        EXCEPTION_HANDLER_FACTORY,
        EXTERNAL_CONTEXT_FACTORY,
        FACES_CONTEXT_FACTORY,
        PARTIAL_VIEW_CONTEXT_FACTORY,
        LIFECYCLE_FACTORY,
        RENDER_KIT_FACTORY,
        VIEW_DECLARATION_LANGUAGE_FACTORY,
        FACELET_CACHE_FACTORY,
        TAG_HANDLER_DELEGATE_FACTORY,
        APPLICATION,
        EL_RESOLVER,
        RESOURCE_HANDLER,
        STATE_MANAGER,
        ACTION_LISTENER,
        NAVIGATION_HANDLER,
        VIEW_HANDLER,
        SYSTEM_EVENT_LISTENER,
        SYSTEM_EVENT_LISTENER_CLASS,
        LIFECYCLE,
        PHASE_LISTENER,
        MANAGED_BEAN,
        MANAGED_BEAN_CLASS;

        private String tagName = this.name().toLowerCase().replaceAll("_", "-");

        public String getTagName() {
            return this.tagName;
        }
    }
}

