/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.parser.jsp.TldMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ExternalTldParsingDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String IMPLICIT_TLD = "implicit.tld";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null || warMetaData.getMergedJBossWebMetaData() == null) {
            return;
        }
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        Map<String, TldMetaData> tlds = tldsMetaData.getTlds();
        HashSet<String> sharedTldUris = new HashSet<String>();
        for (TldMetaData shared : tldsMetaData.getSharedTlds(deploymentUnit)) {
            sharedTldUris.add(shared.getUri());
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        try {
            Iterator resources = module.globResources("META-INF/**.tld");
            while (resources.hasNext()) {
                TldMetaData value;
                Resource resource = (Resource)resources.next();
                if (resource.getURL().toString().contains("com/sun/jsf-impl/main") || !resource.getName().startsWith("META-INF/") || tlds.containsKey(resource.getName()) || resource.getURL().getProtocol().equals("vfs") || sharedTldUris.contains((value = this.parseTLD(resource)).getUri())) continue;
                String key = "/" + resource.getName();
                if (!tlds.containsKey(key)) {
                    tlds.put(key, value);
                }
                if (!tlds.containsKey(value.getUri())) {
                    tlds.put(value.getUri(), value);
                }
                if (value.getListeners() == null) continue;
                for (ListenerMetaData l : value.getListeners()) {
                    ArrayList<ListenerMetaData> listeners = warMetaData.getMergedJBossWebMetaData().getListeners();
                    if (listeners == null) {
                        listeners = new ArrayList<ListenerMetaData>();
                        warMetaData.getMergedJBossWebMetaData().setListeners(listeners);
                    }
                    listeners.add(l);
                }
            }
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private TldMetaData parseTLD(Resource tld) throws DeploymentUnitProcessingException {
        if (IMPLICIT_TLD.equals(tld.getName())) {
            return new TldMetaData();
        }
        InputStream is = null;
        try {
            is = tld.openStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setXMLResolver(NoopXMLResolver.create());
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
            TldMetaData tldMetaData = TldMetaDataParser.parse((XMLStreamReader)xmlReader);
            return tldMetaData;
        }
        catch (XMLStreamException e) {
            throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(tld.getName(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber()), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToParseXMLDescriptor(tld.getName()), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

