/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.SameThreadExecutor;
import java.util.ArrayList;
import java.util.List;

public class GateHandlerWrapper
implements HandlerWrapper {
    private final List<Holder> held = new ArrayList<Holder>();
    private volatile boolean open = false;
    private final int statusCode;

    public GateHandlerWrapper(int statusCode) {
        this.statusCode = statusCode;
    }

    public synchronized void open() {
        this.open = true;
        for (Holder holder : this.held) {
            holder.exchange.dispatch(holder.next);
        }
        this.held.clear();
    }

    public HttpHandler wrap(HttpHandler handler) {
        return new GateHandler(handler);
    }

    private static final class Holder {
        final HttpHandler next;
        final HttpServerExchange exchange;

        private Holder(HttpHandler next, HttpServerExchange exchange) {
            this.next = next;
            this.exchange = exchange;
        }
    }

    private final class GateHandler
    implements HttpHandler {
        private final HttpHandler next;

        private GateHandler(HttpHandler next) {
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(final HttpServerExchange exchange) throws Exception {
            if (GateHandlerWrapper.this.open) {
                this.next.handleRequest(exchange);
                return;
            }
            if (GateHandlerWrapper.this.statusCode > 0) {
                exchange.setStatusCode(GateHandlerWrapper.this.statusCode);
                return;
            }
            GateHandlerWrapper gateHandlerWrapper = GateHandlerWrapper.this;
            synchronized (gateHandlerWrapper) {
                if (GateHandlerWrapper.this.open) {
                    this.next.handleRequest(exchange);
                } else {
                    exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            GateHandlerWrapper gateHandlerWrapper = GateHandlerWrapper.this;
                            synchronized (gateHandlerWrapper) {
                                if (GateHandlerWrapper.this.open) {
                                    exchange.dispatch(GateHandler.this.next);
                                } else {
                                    GateHandlerWrapper.this.held.add(new Holder(GateHandler.this.next, exchange));
                                }
                            }
                        }
                    });
                }
            }
        }
    }
}

