/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionDefinition;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

class MailServerAdd
extends RestartParentResourceAddHandler {
    private final AttributeDefinition[] attributes;

    MailServerAdd(AttributeDefinition[] attributes) {
        super("mail-session");
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition def : this.attributes) {
            def.validateAndSet(operation, model);
        }
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        this.populateModel(operation, resource.getModel());
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
        this.recordCapabilitiesAndRequirements(context, operation, resource);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        MailSessionAdd.installRuntimeServices(context, parentAddress, parentModel);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return MailSessionDefinition.SESSION_CAPABILITY.getCapabilityServiceName(new String[]{parentAddress.getLastElement().getValue()});
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        super.removeServices(context, parentService, parentModel);
        String jndiName = MailSessionAdd.getJndiName(parentModel, context);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isDefaultRequiresRuntime() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode model = context.readResourceFromRoot(context.getCurrentAddress(), false).getModel();
                    if (model.hasDefined(MailServerDefinition.CREDENTIAL_REFERENCE.getName())) {
                        final ModelNode resolvedValue = MailServerDefinition.CREDENTIAL_REFERENCE.resolveModelAttribute(context, model);
                        CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (ModelNode)model, null);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)MailServerDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (ModelNode)resolvedValue);
                            }
                        });
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        super.execute(context, operation);
    }
}

