/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.dmr.ModelNode;

public class BinaryKeyedJDBCStoreResourceDefinition
extends JDBCStoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"binary-keyed-jdbc-store", (String)"BINARY_KEYED_JDBC_STORE");
    static final PathElement PATH = BinaryKeyedJDBCStoreResourceDefinition.pathElement("binary-jdbc");
    static final OperationStepHandler LEGACY_READ_TABLE_HANDLER = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress().append(new PathElement[]{BinaryTableResourceDefinition.PATH});
            ModelNode readResourceOperation = Util.createOperation((String)"read-resource", (PathAddress)address);
            operation.get("attributes-only").set(true);
            context.addStep(readResourceOperation, (OperationStepHandler)new ReadResourceHandler(), context.getCurrentStage());
        }
    };
    static final OperationStepHandler LEGACY_WRITE_TABLE_HANDLER = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress().append(new PathElement[]{BinaryTableResourceDefinition.PATH});
            ModelNode table = Operations.getAttributeValue((ModelNode)operation);
            for (Class attributeClass : Arrays.asList(BinaryTableResourceDefinition.Attribute.class, TableResourceDefinition.Attribute.class, TableResourceDefinition.DeprecatedAttribute.class)) {
                for (Attribute attribute : (Attribute[])attributeClass.getEnumConstants()) {
                    ModelNode writeAttributeOperation = Operations.createWriteAttributeOperation((PathAddress)address, (Attribute)attribute, (ModelNode)table.get(attribute.getName()));
                    context.addStep(writeAttributeOperation, context.getResourceRegistration().getAttributeAccess(PathAddress.pathAddress((PathElement[])new PathElement[]{BinaryTableResourceDefinition.PATH}), attribute.getName()).getWriteHandler(), context.getCurrentStage());
                }
            }
        }
    };

    BinaryKeyedJDBCStoreResourceDefinition() {
        super(PATH, LEGACY_PATH, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{PATH, JDBCStoreResourceDefinition.PATH, WILDCARD_PATH}), new ResourceDescriptorConfigurator());
        this.setDeprecated(InfinispanModel.VERSION_5_0_0.getVersion());
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        registration.registerReadWriteAttribute(DeprecatedAttribute.TABLE.getDefinition(), LEGACY_READ_TABLE_HANDLER, LEGACY_WRITE_TABLE_HANDLER);
        new BinaryTableResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addExtraParameters(DeprecatedAttribute.class).addRequiredChildren(new PathElement[]{BinaryTableResourceDefinition.PATH}).setAddOperationTransformation((UnaryOperator)new JDBCStoreResourceDefinition.TableAttributeTransformation(DeprecatedAttribute.TABLE, BinaryTableResourceDefinition.PATH));
        }
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        TABLE("binary-keyed-table", EnumSet.allOf(BinaryTableResourceDefinition.Attribute.class), EnumSet.allOf(TableResourceDefinition.Attribute.class), EnumSet.allOf(TableResourceDefinition.DeprecatedAttribute.class), EnumSet.complementOf(EnumSet.of(TableResourceDefinition.ColumnAttribute.SEGMENT)));

        private final AttributeDefinition definition;

        @SafeVarargs
        private DeprecatedAttribute(String name, Set<? extends Attribute> ... attributeSets) {
            int size = 0;
            for (Set<? extends Attribute> attributes : attributeSets) {
                size += attributes.size();
            }
            ArrayList<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>(size);
            for (Set<? extends Attribute> attributes : attributeSets) {
                for (Attribute attribute : attributes) {
                    definitions.add((AttributeDefinition)attribute.getDefinition());
                }
            }
            this.definition = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)name, (AttributeDefinition[])definitions.toArray(new AttributeDefinition[size])).setRequired(false)).setDeprecated(InfinispanModel.VERSION_4_0_0.getVersion())).setSuffix("table").build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

