/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jgroups.util.UUID;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class FileStoreServiceConfigurator
extends StoreServiceConfigurator<SoftIndexFileStoreConfiguration, SoftIndexFileStoreConfigurationBuilder> {
    private final String containerName;
    private volatile SupplierDependency<PathManager> pathManager;
    private volatile String relativePath;
    private volatile String relativeTo;
    private volatile String serverTempDirectory;

    FileStoreServiceConfigurator(PathAddress address) {
        super(address, SoftIndexFileStoreConfigurationBuilder.class);
        this.containerName = address.getParent().getParent().getLastElement().getValue();
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(this.pathManager.register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.pathManager = new ServiceSupplierDependency(CommonRequirement.PATH_MANAGER.getServiceName(context));
        this.relativePath = FileStoreResourceDefinition.Attribute.RELATIVE_PATH.resolveModelAttribute((ExpressionResolver)context, model).asString("infinispan" + File.separatorChar + this.containerName);
        this.relativeTo = FileStoreResourceDefinition.Attribute.RELATIVE_TO.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.serverTempDirectory = context.resolveExpressions(new ModelNode("jboss.server.temp.dir")).asString();
        return super.configure(context, model);
    }

    @Override
    public void accept(SoftIndexFileStoreConfigurationBuilder builder) {
        ((SoftIndexFileStoreConfigurationBuilder)builder.segmented(true)).dataLocation(((PathManager)this.pathManager.get()).resolveRelativePathEntry(this.relativePath, this.relativeTo)).indexLocation(((PathManager)this.pathManager.get()).resolveRelativePathEntry(this.relativePath + File.separatorChar + UUID.randomUUID().toString(), this.serverTempDirectory));
    }
}

