/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Host;
import org.wildfly.mod_cluster.undertow.UndertowHost;

public class UndertowContext
implements Context {
    private Deployment deployment;
    private UndertowHost host;

    public UndertowContext(Deployment deployment, UndertowHost host) {
        this.deployment = deployment;
        this.host = host;
    }

    public Host getHost() {
        return this.host;
    }

    public String getPath() {
        String path = this.deployment.getDeploymentInfo().getContextPath();
        return "/".equals(path) ? "" : path;
    }

    public boolean isStarted() {
        return this.deployment.getApplicationListeners().isStarted() && !this.host.isSuspended();
    }

    public void addRequestListener(final org.jboss.modcluster.container.listeners.ServletRequestListener requestListener) {
        ServletRequestListener listener = new ServletRequestListener(){

            public void requestInitialized(ServletRequestEvent sre) {
                requestListener.requestInitialized();
            }

            public void requestDestroyed(ServletRequestEvent sre) {
                requestListener.requestDestroyed();
            }
        };
        ManagedListener ml = new ManagedListener(new ListenerInfo(ServletRequestListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true);
        try {
            ml.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.deployment.getApplicationListeners().addListener(ml);
    }

    public void removeRequestListener(org.jboss.modcluster.container.listeners.ServletRequestListener requestListener) {
    }

    public void addSessionListener(final org.jboss.modcluster.container.listeners.HttpSessionListener sessionListener) {
        HttpSessionListener listener = new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent se) {
                sessionListener.sessionCreated();
            }

            public void sessionDestroyed(HttpSessionEvent se) {
                sessionListener.sessionDestroyed();
            }
        };
        ManagedListener ml = new ManagedListener(new ListenerInfo(HttpSessionListener.class, (InstanceFactory)new ImmediateInstanceFactory((Object)listener)), true);
        try {
            ml.start();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.deployment.getApplicationListeners().addListener(ml);
    }

    public void removeSessionListener(org.jboss.modcluster.container.listeners.HttpSessionListener sessionListener) {
    }

    public int getActiveSessionCount() {
        return this.deployment.getSessionManager().getActiveSessions().size();
    }

    public boolean isDistributable() {
        return !(this.deployment.getDeploymentInfo().getSessionManagerFactory() instanceof InMemorySessionManagerFactory);
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowContext)) {
            return false;
        }
        UndertowContext context = (UndertowContext)object;
        return this.host.equals(context.host) && this.getPath().equals(context.getPath());
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.getPath().hashCode();
    }
}

