/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import io.smallrye.mutiny.helpers.queues.SpscArrayQueue;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscLinkedArrayQueue<E>
extends AbstractQueue<E>
implements Queue<E> {
    private static final int MAX_LOOK_AHEAD_STEP = 4096;
    private final AtomicLong producerIndex = new AtomicLong();
    private int producerLookAheadStep;
    private long producerLookAhead;
    private final int producerMask;
    private AtomicReferenceArray<Object> producerBuffer;
    private final int consumerMask;
    private AtomicReferenceArray<Object> consumerBuffer;
    private final AtomicLong consumerIndex = new AtomicLong();
    private static final Object HAS_NEXT = new Object();

    public SpscLinkedArrayQueue(int bufferSize) {
        int p2capacity = SpscArrayQueue.roundToPowerOfTwo(Math.max(8, bufferSize));
        int mask = p2capacity - 1;
        AtomicReferenceArray buffer = new AtomicReferenceArray(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2capacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLookAhead = (long)mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long index = this.lpProducerIndex();
        int mask = this.producerMask;
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        if (index < this.producerLookAhead) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        int lookAheadStep = this.producerLookAheadStep;
        int lookAheadElementOffset = SpscLinkedArrayQueue.calcWrappedOffset(index + (long)lookAheadStep, mask);
        if (null == SpscLinkedArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLookAhead = index + (long)lookAheadStep - 1L;
            return this.writeToQueue(buffer, e, index, offset);
        }
        if (null == SpscLinkedArrayQueue.lvElement(buffer, SpscLinkedArrayQueue.calcWrappedOffset(index + 1L, mask))) {
            return this.writeToQueue(buffer, e, index, offset);
        }
        this.resize(buffer, index, offset, e, mask);
        return true;
    }

    private boolean writeToQueue(AtomicReferenceArray<Object> buffer, E e, long index, int offset) {
        SpscLinkedArrayQueue.soElement(buffer, offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    private void resize(AtomicReferenceArray<Object> oldBuffer, long currIndex, int offset, E e, long mask) {
        int capacity = oldBuffer.length();
        AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
        this.producerBuffer = newBuffer;
        this.producerLookAhead = currIndex + mask - 1L;
        SpscLinkedArrayQueue.soElement(newBuffer, offset, e);
        this.soNext(oldBuffer, newBuffer);
        SpscLinkedArrayQueue.soElement(oldBuffer, offset, HAS_NEXT);
        this.soProducerIndex(currIndex + 1L);
    }

    private void soNext(AtomicReferenceArray<Object> curr, AtomicReferenceArray<Object> next) {
        SpscLinkedArrayQueue.soElement(curr, SpscLinkedArrayQueue.calcDirectOffset(curr.length() - 1), next);
    }

    private AtomicReferenceArray<Object> lvNextBufferAndUnlink(AtomicReferenceArray<Object> curr, int nextIndex) {
        int nextOffset = SpscLinkedArrayQueue.calcDirectOffset(nextIndex);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)SpscLinkedArrayQueue.lvElement(curr, nextOffset);
        SpscLinkedArrayQueue.soElement(curr, nextOffset, null);
        return nextBuffer;
    }

    @Override
    public E poll() {
        boolean isNextBuffer;
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscLinkedArrayQueue.lvElement(buffer, offset);
        boolean bl = isNextBuffer = e == HAS_NEXT;
        if (null != e && !isNextBuffer) {
            SpscLinkedArrayQueue.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            return (E)e;
        }
        if (isNextBuffer) {
            return this.newBufferPoll(this.lvNextBufferAndUnlink(buffer, mask + 1), index, mask);
        }
        return null;
    }

    private E newBufferPoll(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        Object n = SpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
        if (null != n) {
            SpscLinkedArrayQueue.soElement(nextBuffer, offsetInNew, null);
            this.soConsumerIndex(index + 1L);
        }
        return (E)n;
    }

    @Override
    public E peek() {
        int mask;
        AtomicReferenceArray<Object> buffer = this.consumerBuffer;
        long index = this.lpConsumerIndex();
        int offset = SpscLinkedArrayQueue.calcWrappedOffset(index, mask = this.consumerMask);
        Object e = SpscLinkedArrayQueue.lvElement(buffer, offset);
        if (e == HAS_NEXT) {
            return this.newBufferPeek(this.lvNextBufferAndUnlink(buffer, mask + 1), index, mask);
        }
        return (E)e;
    }

    private E newBufferPeek(AtomicReferenceArray<Object> nextBuffer, long index, int mask) {
        this.consumerBuffer = nextBuffer;
        int offsetInNew = SpscLinkedArrayQueue.calcWrappedOffset(index, mask);
        return (E)SpscLinkedArrayQueue.lvElement(nextBuffer, offsetInNew);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, 4096);
    }

    private long lvProducerIndex() {
        return this.producerIndex.get();
    }

    private long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    private long lpProducerIndex() {
        return this.producerIndex.get();
    }

    private long lpConsumerIndex() {
        return this.consumerIndex.get();
    }

    private void soProducerIndex(long v) {
        this.producerIndex.lazySet(v);
    }

    private void soConsumerIndex(long v) {
        this.consumerIndex.lazySet(v);
    }

    private static int calcWrappedOffset(long index, int mask) {
        return SpscLinkedArrayQueue.calcDirectOffset((int)index & mask);
    }

    private static int calcDirectOffset(int index) {
        return index;
    }

    private static void soElement(AtomicReferenceArray<Object> buffer, int offset, Object e) {
        buffer.lazySet(offset, e);
    }

    private static Object lvElement(AtomicReferenceArray<Object> buffer, int offset) {
        return buffer.get(offset);
    }

    public boolean offer(E first, E second) {
        int m;
        AtomicReferenceArray<Object> buffer = this.producerBuffer;
        long p = this.lvProducerIndex();
        int pi = SpscLinkedArrayQueue.calcWrappedOffset(p + 2L, m = this.producerMask);
        if (null == SpscLinkedArrayQueue.lvElement(buffer, pi)) {
            pi = SpscLinkedArrayQueue.calcWrappedOffset(p, m);
            SpscLinkedArrayQueue.soElement(buffer, pi + 1, second);
            SpscLinkedArrayQueue.soElement(buffer, pi, first);
            this.soProducerIndex(p + 2L);
        } else {
            int capacity = buffer.length();
            AtomicReferenceArray<Object> newBuffer = new AtomicReferenceArray<Object>(capacity);
            this.producerBuffer = newBuffer;
            pi = SpscLinkedArrayQueue.calcWrappedOffset(p, m);
            SpscLinkedArrayQueue.soElement(newBuffer, pi + 1, second);
            SpscLinkedArrayQueue.soElement(newBuffer, pi, first);
            this.soNext(buffer, newBuffer);
            SpscLinkedArrayQueue.soElement(buffer, pi, HAS_NEXT);
            this.soProducerIndex(p + 2L);
        }
        return true;
    }
}

