/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.Collections;
import java.util.Iterator;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.LevelTranslator;

class JBossLogger
extends AbstractLogger {
    private final Logger logger;
    private final LevelTranslator levelTranslator = LevelTranslator.getInstance();

    JBossLogger(Logger logger, MessageFactory messageFactory) {
        super(logger.getName(), messageFactory);
        this.logger = logger;
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.logger.isLoggable(this.levelTranslator.translateLevel(level));
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        if (message != null) {
            ExtLogRecord record = new ExtLogRecord(this.levelTranslator.translateLevel(level), message.getFormattedMessage(), ExtLogRecord.FormatStyle.NO_FORMAT, fqcn);
            if (message.getParameters() != null) {
                record.setParameters(message.getParameters());
            }
            if (ThreadContext.isEmpty()) {
                record.setMdc(Collections.emptyMap());
            } else {
                record.setMdc(ThreadContext.getContext());
            }
            record.setNdc(this.getNdc());
            record.setThrown(t == null ? message.getThrowable() : t);
            this.logger.log((LogRecord)record);
        }
    }

    public Level getLevel() {
        java.util.logging.Level level = this.logger.getLevel();
        if (level != null) {
            return this.levelTranslator.translateLevel(level);
        }
        return this.levelTranslator.translateLevel(this.logger.getEffectiveLevel());
    }

    private String getNdc() {
        ThreadContext.ContextStack contextStack = ThreadContext.getImmutableStack();
        if (contextStack.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator iter = contextStack.iterator();
        while (iter.hasNext()) {
            result.append((String)iter.next());
            if (!iter.hasNext()) continue;
            result.append('.');
        }
        return result.toString();
    }
}

