/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst.at.participants;

import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicCancelException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicConfirmException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicHazardException;
import com.arjuna.mw.wscf.model.twophase.exceptions.HeuristicMixedException;
import com.arjuna.mw.wscf.model.twophase.participants.Synchronization;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.wst.Prepared;
import com.arjuna.wst.ReadOnly;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.Vote;
import com.arjuna.wst.WrongStateException;
import java.util.Arrays;
import java.util.List;

public class VolatileTwoPhaseCommitParticipant
implements Synchronization {
    private Volatile2PCParticipant _resource = null;
    private boolean _readonly = false;

    public VolatileTwoPhaseCommitParticipant(Volatile2PCParticipant resource) {
        this._resource = resource;
    }

    @Override
    public void beforeCompletion() throws SystemException {
        block7: {
            try {
                if (this._resource != null) {
                    Vote vt = this._resource.prepare();
                    if (vt instanceof ReadOnly) {
                        this._readonly = true;
                    } else if (!(vt instanceof Prepared)) {
                        List<Class<?>> expected = Arrays.asList(ReadOnly.class, Prepared.class);
                        wstxLogger.i18NLogger.error_wst_at_participants_Volatile2PC_prepare_wrong_type(vt, this._resource, expected);
                        throw new SystemException("participant on before completion preparation resulted in wrong vote result " + vt);
                    }
                    break block7;
                }
                wstxLogger.i18NLogger.error_wst_at_participants_Volatile2PC_prepare_is_null();
                throw new SystemException("participant to prepare is null");
            }
            catch (SystemException ex) {
                throw ex;
            }
            catch (Exception ex) {
                wstxLogger.i18NLogger.error_wst_at_participants_Volatile2PC_prepare(this._resource, ex);
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        }
    }

    @Override
    public void afterCompletion(int status) throws SystemException {
        if (!this._readonly) {
            try {
                switch (status) {
                    case 0: {
                        this.confirm();
                        break;
                    }
                    default: {
                        this.cancel();
                        break;
                    }
                }
            }
            catch (SystemException ex) {
                throw ex;
            }
            catch (Exception ex) {
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        }
    }

    private final void confirm() throws InvalidParticipantException, com.arjuna.mw.wsas.exceptions.WrongStateException, HeuristicHazardException, HeuristicMixedException, HeuristicCancelException, SystemException {
        if (this._resource != null) {
            try {
                this._resource.commit();
            }
            catch (WrongStateException ex) {
                com.arjuna.mw.wsas.exceptions.WrongStateException wse = new com.arjuna.mw.wsas.exceptions.WrongStateException(ex.toString());
                wse.addSuppressed(ex);
                throw wse;
            }
            catch (com.arjuna.wst.SystemException ex) {
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        } else {
            wstxLogger.i18NLogger.error_wst_at_participants_Volatile2PC_confirm_is_null();
            throw new InvalidParticipantException("participant to confirm is null");
        }
    }

    private final void cancel() throws InvalidParticipantException, com.arjuna.mw.wsas.exceptions.WrongStateException, HeuristicHazardException, HeuristicMixedException, HeuristicConfirmException, SystemException {
        if (this._resource != null) {
            try {
                this._resource.rollback();
            }
            catch (WrongStateException ex) {
                com.arjuna.mw.wsas.exceptions.WrongStateException wse = new com.arjuna.mw.wsas.exceptions.WrongStateException(ex.toString());
                wse.addSuppressed(ex);
                throw wse;
            }
            catch (com.arjuna.wst.SystemException ex) {
                SystemException se = new SystemException(ex.toString());
                se.addSuppressed(ex);
                throw se;
            }
        } else {
            wstxLogger.i18NLogger.error_wst_at_participants_Volatile2PC_cancel_is_null();
            throw new InvalidParticipantException("praticipant to cancel is null");
        }
    }
}

