/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;

public class MethodPermissionsMetaData
extends ArrayList<MethodPermissionMetaData>
implements IdMetaData {
    private static final long serialVersionUID = -1393413242478179085L;
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MethodPermissionsMetaData getMethodPermissionsByEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        if (this.isEmpty()) {
            return null;
        }
        ArrayList result = null;
        for (MethodPermissionMetaData permission : this) {
            MethodPermissionMetaData ejbPermission = permission.getMethodPermissionByEjbName(ejbName);
            if (ejbPermission == null) continue;
            if (result == null) {
                result = new MethodPermissionsMetaData();
            }
            result.add(ejbPermission);
        }
        return result;
    }

    public void merge(MethodPermissionsMetaData override, MethodPermissionsMetaData original) {
        if (override == null && original == null) {
            return;
        }
        if (override == null) {
            this.addAll(original);
        } else if (original == null) {
            this.addAll(override);
        } else {
            HashSet<MethodMetaData> overridenMethods = new HashSet<MethodMetaData>();
            for (MethodPermissionMetaData permission : override) {
                this.add(permission);
                if (permission.getMethods() == null) continue;
                for (MethodMetaData method : permission.getMethods()) {
                    overridenMethods.add(method);
                }
            }
            for (MethodPermissionMetaData permission : original) {
                MethodPermissionMetaData newPermission = new MethodPermissionMetaData();
                newPermission.setMethods(new MethodsMetaData());
                newPermission.setRoles(permission.getRoles());
                if (permission.getMethods() != null) {
                    for (MethodMetaData method : permission.getMethods()) {
                        if (overridenMethods.contains((Object)method)) continue;
                        newPermission.getMethods().add(method);
                    }
                }
                if (newPermission.getMethods().isEmpty()) continue;
                this.add(newPermission);
            }
        }
    }
}

