/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.jakarta;

import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.RollbackException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;

public interface ExceptionAdapter {
    public static final Function<String, javax.transaction.HeuristicCommitException> HEURISTIC_COMMIT_EXCEPTION_FACTORY = javax.transaction.HeuristicCommitException::new;
    public static final Function<String, javax.transaction.HeuristicMixedException> HEURISTIC_MIXED_EXCEPTION_FACTORY = javax.transaction.HeuristicMixedException::new;
    public static final Function<String, HeuristicRollbackException> HEURISTIC_ROLLBACK_EXCEPTION_FACTORY = HeuristicRollbackException::new;
    public static final Function<String, javax.transaction.RollbackException> ROLLBACK_EXCEPTION_FACTORY = javax.transaction.RollbackException::new;

    public static <S extends Throwable, T extends Throwable> T adapt(S source, Supplier<T> factory) {
        Throwable result = (Throwable)factory.get();
        result.initCause(source.getCause());
        result.setStackTrace(source.getStackTrace());
        return (T)result;
    }

    public static <S extends Throwable, T extends Throwable> T adapt(final S source, final Function<String, T> factory) {
        return ExceptionAdapter.adapt(source, new Supplier<T>(){

            @Override
            public T get() {
                return (Throwable)factory.apply(source.getMessage());
            }
        });
    }

    public static javax.transaction.HeuristicCommitException adapt(HeuristicCommitException source) {
        return ExceptionAdapter.adapt(source, HEURISTIC_COMMIT_EXCEPTION_FACTORY);
    }

    public static javax.transaction.HeuristicMixedException adapt(HeuristicMixedException source) {
        return ExceptionAdapter.adapt(source, HEURISTIC_MIXED_EXCEPTION_FACTORY);
    }

    public static HeuristicRollbackException adapt(jakarta.transaction.HeuristicRollbackException source) {
        return ExceptionAdapter.adapt(source, HEURISTIC_ROLLBACK_EXCEPTION_FACTORY);
    }

    public static javax.transaction.RollbackException adapt(RollbackException source) {
        return ExceptionAdapter.adapt(source, ROLLBACK_EXCEPTION_FACTORY);
    }

    public static SystemException adapt(final jakarta.transaction.SystemException source) {
        return ExceptionAdapter.adapt(source, new Supplier<SystemException>(){

            @Override
            public SystemException get() {
                return source.errorCode != 0 ? new SystemException(source.errorCode) : new SystemException(source.getMessage());
            }
        });
    }
}

