/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.util.Util;

class IndexRequest
extends CompletableFuture<Object> {
    private final Type type;
    private final int segment;
    private final Object key;
    private final int file;
    private final int offset;
    private final int prevFile;
    private final int prevOffset;
    private final byte[] serializedKey;
    private final int size;

    private IndexRequest(Type type, int segment, Object key, byte[] serializedKey, int file, int offset, int size, int prevFile, int prevOffset) {
        this.type = type;
        this.segment = segment;
        this.key = key;
        this.file = file;
        this.offset = offset;
        this.prevFile = prevFile;
        this.prevOffset = prevOffset;
        this.serializedKey = serializedKey;
        this.size = size;
    }

    public static IndexRequest update(int segment, Object key, byte[] serializedKey, int file, int offset, int size) {
        return new IndexRequest(Type.UPDATE, segment, Objects.requireNonNull(key), serializedKey, file, offset, size, -1, -1);
    }

    public static IndexRequest moved(int segment, Object key, byte[] serializedKey, int file, int offset, int size, int prevFile, int prevOffset) {
        return new IndexRequest(Type.MOVED, segment, Objects.requireNonNull(key), serializedKey, file, offset, size, prevFile, prevOffset);
    }

    public static IndexRequest dropped(int segment, Object key, byte[] serializedKey, int prevFile, int prevOffset) {
        return new IndexRequest(Type.DROPPED, segment, Objects.requireNonNull(key), serializedKey, -1, -1, -1, prevFile, prevOffset);
    }

    public static IndexRequest foundOld(int segment, Object key, byte[] serializedKey, int prevFile, int prevOffset) {
        return new IndexRequest(Type.FOUND_OLD, segment, Objects.requireNonNull(key), serializedKey, -1, -1, -1, prevFile, prevOffset);
    }

    public static IndexRequest clearRequest() {
        return new IndexRequest(Type.CLEAR, -1, null, null, -1, -1, -1, -1, -1);
    }

    public static IndexRequest syncRequest(Runnable runnable) {
        return new IndexRequest(Type.SYNC_REQUEST, -1, runnable, null, -1, -1, -1, -1, -1);
    }

    public static IndexRequest sizeRequest() {
        return new IndexRequest(Type.SIZE, -1, null, null, -1, -1, -1, -1, -1);
    }

    public Type getType() {
        return this.type;
    }

    public int getSegment() {
        return this.segment;
    }

    public Object getKey() {
        return this.key;
    }

    public long getPrevFile() {
        return this.prevFile;
    }

    public int getPrevOffset() {
        return this.prevOffset;
    }

    public byte[] getSerializedKey() {
        return this.serializedKey;
    }

    public int getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public String toString() {
        return "IndexRequest{key=" + this.key + ", serializedKey=" + Util.printArray((byte[])this.serializedKey) + ", file=" + this.file + ", offset=" + this.offset + ", prevFile=" + this.prevFile + ", prevOffset=" + this.prevOffset + ", size=" + this.size + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        UPDATE,
        MOVED,
        DROPPED,
        FOUND_OLD,
        CLEAR,
        SYNC_REQUEST,
        SIZE;

    }
}

