/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.logging;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.OpenType;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYJMX", length=4)
public interface JmxLogger
extends BasicLogger {
    public static final JmxLogger ROOT_LOGGER = (JmxLogger)Logger.getMessageLogger(JmxLogger.class, (String)"org.jboss.as.jmx");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="No ObjectName available to unregister")
    public void cannotUnregisterObject();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed to unregister [%s]")
    public void unregistrationFailure(@Cause Throwable var1, ObjectName var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="<jmx-connector/> is no longer supporting. <remoting-connector/> should be used instead to allow remote connections via JBoss Remoting.")
    public void jmxConnectorNotSupported();

    @Message(id=0, value="entry")
    public String compositeEntryTypeName();

    @Message(id=0, value="An entry")
    public String compositeEntryTypeDescription();

    @Message(id=0, value="The key")
    public String compositeEntryKeyDescription();

    @Message(id=0, value="The value")
    public String compositeEntryValueDescription();

    @Message(id=0, value="A map")
    public String compositeMapName();

    @Message(id=0, value="The map is indexed by 'key'")
    public String compositeMapDescription();

    @Message(id=0, value="Complex type")
    public String complexCompositeEntryTypeName();

    @Message(id=0, value="A complex type")
    public String complexCompositeEntryTypeDescription();

    @Message(id=0, value="This mbean does not support expressions for attributes or operation parameters, even when supported by the underlying model. Instead the resolved attribute is returned, and the real typed value must be used when writing attributes/invoking operations.")
    public String descriptorMBeanExpressionSupportFalse();

    @Message(id=0, value="This mbean supports raw expressions for attributes and operation parameters where supported by the underlying model. If no expression is used, the string representation is converted into the real attribute value.")
    public String descriptorMBeanExpressionSupportTrue();

    @Message(id=0, value="To be able to set and read expressions go to %s")
    public String descriptorAlternateMBeanExpressions(ObjectName var1);

    @Message(id=0, value="To read resolved values and to write typed attributes and use typed operation parameters go to %s")
    public String descriptorAlternateMBeanLegacy(ObjectName var1);

    @Message(id=0, value="This attribute supports expressions")
    public String descriptorAttributeExpressionsAllowedTrue();

    @Message(id=0, value="This attribute does not support expressions")
    public String descriptorAttributeExpressionsAllowedFalse();

    @Message(id=0, value="A composite type representing a property")
    public String propertyCompositeType();

    @Message(id=0, value="The property name")
    public String propertyName();

    @Message(id=0, value="The property value")
    public String propertyValue();

    @Message(id=7, value="Could not find any attribute matching: %s")
    public AttributeNotFoundException attributeNotFound(String var1);

    @Message(id=8, value="Attribute %s is not writable")
    public AttributeNotFoundException attributeNotWritable(Attribute var1);

    @Message(id=9, value="Could not create ObjectName for address %s from string %s")
    public RuntimeException cannotCreateObjectName(@Cause Throwable var1, PathAddress var2, String var3);

    @Message(id=10, value="Could not set %s")
    public ReflectionException cannotSetAttribute(@Cause Exception var1, String var2);

    @Message(id=12, value="%s and %s have different lengths")
    public IllegalArgumentException differentLengths(String var1, String var2);

    @Message(id=13, value="Bad type for '%s'")
    public InvalidAttributeValueException invalidAttributeType(@Cause Throwable var1, String var2);

    @Message(id=14, value="Invalid key %s for %s")
    public IllegalArgumentException invalidKey(List<?> var1, Map.Entry<?, Object> var2);

    @Message(id=15, value="Invalid ObjectName: %s; %s")
    public Error invalidObjectName(String var1, String var2);

    @Message(id=-1, value="Invalid ObjectName: %s,%s; %s")
    public Error invalidObjectName(String var1, Hashtable<String, String> var2, String var3);

    @Message(id=-1, value="Invalid ObjectName: %s,%s,%s; %s")
    public Error invalidObjectName(String var1, String var2, String var3, String var4);

    @Message(id=17, value="No MBean found with name %s")
    public InstanceNotFoundException mbeanNotFound(ObjectName var1);

    @Message(id=18, value="Failed to register mbean [%s]")
    public StartException mbeanRegistrationFailed(@Cause Throwable var1, String var2);

    @Message(id=19, value="No operation called '%s'")
    public InstanceNotFoundException noOperationCalled(String var1);

    @Message(id=20, value="No operation called '%s' at %s")
    public MBeanException noOperationCalled(@Cause Exception var1, String var2, PathAddress var3);

    @Message(id=22, value="No registration found for path address %s")
    public InstanceNotFoundException registrationNotFound(PathAddress var1);

    @Message(id=24, value="Unknown type %s")
    public RuntimeException unknownType(ModelType var1);

    @Message(id=25, value="Unknown value %s")
    public IllegalArgumentException unknownValue(Object var1);

    @Message(id=26, value="Need the name parameter for wildcard add")
    public IllegalStateException wildcardNameParameterRequired();

    @Message(id=29, value="Unknown domain: %s")
    public IllegalArgumentException unknownDomain(String var1);

    @Message(id=30, value="Expression can not be converted into target type %s")
    public IllegalArgumentException expressionCannotBeConvertedIntoTargeteType(OpenType<?> var1);

    @Message(id=31, value="Unknown child %s")
    public IllegalArgumentException unknownChild(String var1);

    @Message(id=32, value="ObjectName cannot be null")
    public IllegalArgumentException objectNameCantBeNull();

    @Message(id=36, value="There is no handler called '%s'")
    public IllegalStateException noHandlerCalled(String var1);

    @Message(id=37, value="Unauthorized access")
    public JMRuntimeException unauthorized();

    @Message(id=38, value="Not authorized to write attribute: '%s'")
    public JMRuntimeException notAuthorizedToWriteAttribute(String var1);

    @Message(id=39, value="Not authorized to read attribute: '%s'")
    public JMRuntimeException notAuthorizedToReadAttribute(String var1);

    @Message(id=40, value="Not authorized to invoke operation: '%s'")
    public JMRuntimeException notAuthorizedToExecuteOperation(String var1);

    @Message(id=41, value="You can't create mbeans under the reserved domain '%s'")
    public NotCompliantMBeanException cannotCreateMBeansInReservedDomain(String var1);

    @Message(id=42, value="Don't know how to deserialize")
    public OperationsException dontKnowHowToDeserialize();

    @Message(id=43, value="%s is not supported")
    public UnsupportedOperationException unsupportedMethod(String var1);

    @Message(id=44, value="You can't register mbeans under the reserved domain '%s'")
    public String cannotRegisterMBeansUnderReservedDomain(String var1);

    @Message(id=45, value="You can't unregister mbeans under the reserved domain '%s'")
    public String cannotUnregisterMBeansUnderReservedDomain(String var1);

    @Message(id=46, value="The ObjectName coming from MBeanRegistration.preRegister() '%s' is in a reserved JMX domain")
    public RuntimeOperationsException badDomainInCalclulatedObjectNameException(ObjectName var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=47, value="An error happened unregistering the '%s' MBean registered in a reserved JMX domain")
    public void errorUnregisteringMBeanWithBadCalculatedName(@Cause Exception var1, ObjectName var2);

    @Message(id=48, value="Add notification listener using ObjectName %s is not supported")
    public UnsupportedOperationException addNotificationListerWithObjectNameNotSupported(ObjectName var1);

    @Message(id=49, value="Remove notification listener using ObjectName %s is not supported")
    public UnsupportedOperationException removeNotificationListerWithObjectNameNotSupported(ObjectName var1);

    @Message(id=50, value="Add notification listener using ObjectName %s is not supported")
    public UnsupportedOperationException addNotificationListenerNotAllowed(ObjectName var1);

    @Message(id=51, value="Remove notification listener using ObjectName %s is not supported")
    public UnsupportedOperationException removeNotificationListenerNotAllowed(ObjectName var1);
}

