/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.service.ConfigService;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class ClientConfigAdd
extends AbstractAddStepHandler {
    static final ClientConfigAdd INSTANCE = new ClientConfigAdd();

    private ClientConfigAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = context.getCurrentAddress();
            String name = context.getCurrentAddressValue();
            ServiceName serviceName = PackageUtils.getClientConfigServiceName(name);
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder clientServiceBuilder = target.addService(serviceName);
            ArrayList<Supplier<PropertyService>> propertySuppliers = new ArrayList<Supplier<PropertyService>>();
            for (ServiceName serviceName2 : PackageUtils.getServiceNameDependencies(context, serviceName, address, "property")) {
                propertySuppliers.add(clientServiceBuilder.requires(serviceName2));
            }
            ArrayList<Supplier<UnifiedHandlerChainMetaData>> preHandlerChainSuppliers = new ArrayList<Supplier<UnifiedHandlerChainMetaData>>();
            for (ServiceName serviceName3 : PackageUtils.getServiceNameDependencies(context, serviceName, address, "pre-handler-chain")) {
                preHandlerChainSuppliers.add(clientServiceBuilder.requires(serviceName3));
            }
            ArrayList<Supplier<UnifiedHandlerChainMetaData>> arrayList = new ArrayList<Supplier<UnifiedHandlerChainMetaData>>();
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "post-handler-chain")) {
                arrayList.add(clientServiceBuilder.requires(sn));
            }
            Consumer consumer = clientServiceBuilder.provides(new ServiceName[]{serviceName});
            clientServiceBuilder.setInstance((Service)new ConfigService(name, true, consumer, propertySuppliers, preHandlerChainSuppliers, arrayList));
            clientServiceBuilder.install();
        } else {
            context.reloadRequired();
        }
    }
}

