/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.util.function.Predicate;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.keystore.UnmodifiableKeyStore;

class FilteringKeyStoreService
implements ModifiableKeyStoreService {
    final InjectedValue<KeyStore> keyStoreInjector;
    final String aliasFilter;
    KeyStore filteringKeyStore;
    KeyStore modifiableFilteringKeyStore;

    FilteringKeyStoreService(InjectedValue<KeyStore> keyStoreInjector, String aliasFilter) {
        this.keyStoreInjector = keyStoreInjector;
        this.aliasFilter = aliasFilter;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            KeyStore keyStore = (KeyStore)this.keyStoreInjector.getValue();
            AliasFilter filter = AliasFilter.fromString((String)this.aliasFilter);
            KeyStore unmodifiable = UnmodifiableKeyStore.unmodifiableKeyStore((KeyStore)keyStore);
            KeyStore modifiable = keyStore;
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("starting:  aliasFilter = %s  filter = %s  unmodifiable = %s  modifiable = %s", new Object[]{this.aliasFilter, filter, unmodifiable, modifiable});
            this.filteringKeyStore = FilteringKeyStore.filteringKeyStore((KeyStore)unmodifiable, (Predicate)filter);
            if (this.modifiableFilteringKeyStore == null) {
                this.modifiableFilteringKeyStore = FilteringKeyStore.filteringKeyStore((KeyStore)modifiable, (Predicate)filter);
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext stopContext) {
        ElytronSubsystemMessages.ROOT_LOGGER.tracef("stopping:  filteringKeyStore = %s  modifiableFilteringKeyStore = %s", this.filteringKeyStore, this.modifiableFilteringKeyStore);
        this.filteringKeyStore = null;
        this.modifiableFilteringKeyStore = null;
    }

    public KeyStore getValue() throws IllegalStateException, IllegalArgumentException {
        return this.filteringKeyStore;
    }

    @Override
    public KeyStore getModifiableValue() {
        if (this.modifiableFilteringKeyStore == null) {
            throw new UnsupportedOperationException();
        }
        return this.modifiableFilteringKeyStore;
    }
}

