/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.NamingCloseable;

public interface CloseableNamingEnumeration<T>
extends NamingEnumeration<T>,
NamingCloseable {
    public static final CloseableNamingEnumeration<?> EMPTY = CloseableNamingEnumeration.fromEnumeration(Collections.emptyEnumeration());

    @Override
    public void close() throws NamingException;

    public static <T> CloseableNamingEnumeration<T> fromIterable(Iterable<T> iterable) {
        Assert.checkNotNullParam((String)"iterable", iterable);
        return CloseableNamingEnumeration.fromIterator(iterable.iterator());
    }

    public static <T> CloseableNamingEnumeration<T> fromIterator(final Iterator<T> iterator) {
        Assert.checkNotNullParam((String)"iterator", iterator);
        return new CloseableNamingEnumeration<T>(){

            @Override
            public T next() {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() {
                return this.hasMoreElements();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> CloseableNamingEnumeration<T> fromEnumeration(final Enumeration<T> enumeration) {
        Assert.checkNotNullParam((String)"enumeration", enumeration);
        if (enumeration instanceof CloseableNamingEnumeration) {
            return (CloseableNamingEnumeration)enumeration;
        }
        if (enumeration instanceof NamingEnumeration) {
            return CloseableNamingEnumeration.fromEnumeration((NamingEnumeration)enumeration);
        }
        return new CloseableNamingEnumeration<T>(){

            @Override
            public T next() {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() {
                return this.hasMoreElements();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T nextElement() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> CloseableNamingEnumeration<T> fromEnumeration(final NamingEnumeration<T> enumeration) {
        Assert.checkNotNullParam((String)"enumeration", enumeration);
        if (enumeration instanceof CloseableNamingEnumeration) {
            return (CloseableNamingEnumeration)enumeration;
        }
        return new CloseableNamingEnumeration<T>(){

            @Override
            public T next() throws NamingException {
                return enumeration.next();
            }

            @Override
            public boolean hasMore() throws NamingException {
                return enumeration.hasMore();
            }

            @Override
            public void close() throws NamingException {
                enumeration.close();
            }

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T nextElement() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> CloseableNamingEnumeration<T> empty() {
        return EMPTY;
    }
}

