/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.concurrent.Executor;

public class TracedExecutor
implements Executor {
    protected final Tracer tracer;
    private final Executor delegate;
    private final boolean traceWithActiveSpanOnly;

    public TracedExecutor(Executor executor, Tracer tracer) {
        this(executor, tracer, true);
    }

    public TracedExecutor(Executor executor, Tracer tracer, boolean traceWithActiveSpanOnly) {
        this.delegate = executor;
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        Span span = this.createSpan("execute");
        try {
            Span toActivate = span != null ? span : this.tracer.activeSpan();
            this.delegate.execute(toActivate == null ? runnable : new TracedRunnable(runnable, this.tracer, toActivate));
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    Span createSpan(String operationName) {
        if (this.tracer.activeSpan() == null && !this.traceWithActiveSpanOnly) {
            return this.tracer.buildSpan(operationName).start();
        }
        return null;
    }
}

