/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.DirectoryStructure;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.PatchableTargetsArtifact;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingFileArtifact;

class PatchingOverlayDirArtifact
extends AbstractArtifact<PatchableTargetsArtifact.PatchableTargetState, PatchingFileArtifact.DirectoryArtifactState>
implements PatchingFileArtifact<PatchableTargetsArtifact.PatchableTargetState, PatchingFileArtifact.DirectoryArtifactState> {
    private final boolean bundles;

    protected PatchingOverlayDirArtifact(boolean bundles, PatchingArtifact<PatchingFileArtifact.DirectoryArtifactState, ? extends PatchingArtifact.ArtifactState> ... artifacts) {
        super(artifacts);
        this.bundles = bundles;
    }

    @Override
    public boolean process(PatchableTargetsArtifact.PatchableTargetState parent, PatchingArtifactProcessor processor) {
        if (this.bundles && !parent.isCheckBundles()) {
            return true;
        }
        if (!parent.isCheckModules()) {
            return true;
        }
        String patchID = parent.getPatchID();
        DirectoryStructure structure = parent.getStructure();
        File overlay = this.bundles ? structure.getBundlesPatchDirectory(patchID) : structure.getModulePatchDirectory(patchID);
        PatchingFileArtifact.DirectoryArtifactState state = new PatchingFileArtifact.DirectoryArtifactState(overlay, this);
        return processor.process(this, state);
    }
}

