/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementServiceConfigurator;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;

public class HotRodSessionManagementServiceConfigurator
extends SessionManagementServiceConfigurator<DistributableSessionManagementConfiguration>
implements HotRodSessionManagementConfiguration {
    private volatile String containerName;
    private volatile String configurationName;

    HotRodSessionManagementServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = HotRodSessionManagementResourceDefinition.Attribute.REMOTE_CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.configurationName = HotRodSessionManagementResourceDefinition.Attribute.CACHE_CONFIGURATION.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return super.configure(context, model);
    }

    @Override
    public DistributableSessionManagementProvider get() {
        return new HotRodSessionManagementProvider(this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }
}

