/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public enum ScalarClass implements ScalarMarshaller<Class<?>>
{
    ANY(WireType.LENGTH_DELIMITED){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            return reader.readObject(Class.class);
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeObjectNoTag(value);
        }
    }
    ,
    ID(WireType.VARINT){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            int typeId = reader.readUInt32();
            ImmutableSerializationContext context = reader.getSerializationContext();
            String typeName = context.getDescriptorByTypeId(Integer.valueOf(typeId)).getFullName();
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            ProtoStreamMarshaller marshaller = writer.findMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = writer.getSerializationContext().getDescriptorByName(typeName).getTypeId();
            writer.writeVarint32(typeId);
        }
    }
    ,
    NAME(WireType.LENGTH_DELIMITED){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            String typeName = StandardCharsets.UTF_8.decode(reader.readByteBuffer()).toString();
            BaseMarshaller marshaller = reader.getSerializationContext().getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            ProtoStreamMarshaller marshaller = writer.findMarshaller(value);
            String typeName = marshaller.getTypeName();
            Scalar.BYTE_BUFFER.writeTo(writer, StandardCharsets.UTF_8.encode(typeName));
        }
    }
    ,
    FIELD(WireType.VARINT){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            return AnyField.fromIndex(reader.readUInt32() + 1).getMarshaller().getJavaClass();
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeVarint32(AnyField.fromJavaType(value).getIndex() - 1);
        }
    };

    private final WireType wireType;

    private ScalarClass(WireType wireType) {
        this.wireType = wireType;
    }

    @Override
    public Class<? extends Class<?>> getJavaClass() {
        return Class.class;
    }

    @Override
    public WireType getWireType() {
        return this.wireType;
    }
}

