/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.time.Duration;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryServiceConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ejb.BeanManagementProvider;
import org.wildfly.clustering.ejb.StatefulBeanConfiguration;
import org.wildfly.clustering.service.SupplierDependency;

public abstract class AbstractDistributableCacheFactoryBuilderServiceConfigurator<K, V extends Identifiable<K> & Contextual<Batch>>
extends DistributableCacheFactoryBuilderServiceNameProvider
implements ResourceServiceConfigurator,
CacheFactoryBuilder<K, V>,
Consumer<SupplierDependency<BeanManagementProvider>> {
    private volatile SupplierDependency<BeanManagementProvider> provider;

    public AbstractDistributableCacheFactoryBuilderServiceConfigurator(PathAddress address) {
        super(address.getLastElement().getValue());
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer cacheFactoryBuilder = this.provider.register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)cacheFactoryBuilder, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public void accept(SupplierDependency<BeanManagementProvider> provider) {
        this.provider = provider;
    }

    @Override
    public Iterable<CapabilityServiceConfigurator> getDeploymentServiceConfigurators(DeploymentUnit unit) {
        return ((BeanManagementProvider)this.provider.get()).getDeploymentServiceConfigurators(unit.getServiceName());
    }

    @Override
    public CapabilityServiceConfigurator getServiceConfigurator(final DeploymentUnit unit, final StatefulComponentDescription description, final ComponentConfiguration configuration) {
        StatefulBeanConfiguration statefulBeanConfiguration = new StatefulBeanConfiguration(){

            public String getName() {
                return configuration.getComponentName();
            }

            public ServiceName getDeploymentUnitServiceName() {
                return unit.getServiceName();
            }

            public Module getModule() {
                return (Module)unit.getAttachment(Attachments.MODULE);
            }

            public Duration getTimeout() {
                StatefulTimeoutInfo info = description.getStatefulTimeout();
                return info != null && info.getValue() >= 0L ? Duration.of(info.getValue(), info.getTimeUnit().toChronoUnit()) : null;
            }
        };
        CapabilityServiceConfigurator configurator = ((BeanManagementProvider)this.provider.get()).getBeanManagerFactoryServiceConfigurator(statefulBeanConfiguration);
        return new DistributableCacheFactoryServiceConfigurator(description.getCacheFactoryServiceName(), configurator);
    }

    @Override
    public boolean supportsPassivation() {
        return true;
    }
}

