/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.InvocationMessages;
import org.wildfly.common.Assert;

public final class MethodInterceptor
implements Interceptor {
    private final Object interceptorInstance;
    private final Method method;
    private final boolean withContext;
    private final boolean changeMethod;

    public MethodInterceptor(Object interceptorInstance, Method method, boolean changeMethod) {
        Assert.checkNotNullParam((String)"interceptorInstance", (Object)interceptorInstance);
        Assert.checkNotNullParam((String)"method", (Object)method);
        this.changeMethod = changeMethod;
        this.method = method;
        this.interceptorInstance = interceptorInstance;
        this.checkMethodType(interceptorInstance);
        this.withContext = method.getParameterTypes().length == 1;
    }

    public MethodInterceptor(Object interceptorInstance, Method method) {
        this(interceptorInstance, method, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        try {
            Method method = this.method;
            if (!this.withContext) {
                method.invoke(this.interceptorInstance, null);
                return context.proceed();
            }
            if (!this.changeMethod) {
                return method.invoke(this.interceptorInstance, context.getInvocationContext());
            }
            Method oldMethod = context.getMethod();
            context.setMethod(method);
            try {
                Object object = method.invoke(this.interceptorInstance, context.getInvocationContext());
                return object;
            }
            finally {
                context.setMethod(oldMethod);
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow(e.getCause());
        }
    }

    private void checkMethodType(Object interceptorInstance) {
        Method method = this.method;
        if (!method.getDeclaringClass().isInstance(interceptorInstance)) {
            throw InvocationMessages.msg.wrongInterceptorType();
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) && !method.isAccessible()) {
            throw InvocationMessages.msg.interceptorInaccessible();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        int length = parameterTypes.length;
        if (length > 1) {
            throw InvocationMessages.msg.interceptorTargetOneParam();
        }
        if (length == 1 && !parameterTypes[0].isAssignableFrom(InvocationContext.class)) {
            throw InvocationMessages.msg.interceptorTargetAssignableFrom(InvocationContext.class);
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && !Object.class.isAssignableFrom(returnType)) {
            throw InvocationMessages.msg.interceptorReturnObject();
        }
    }
}

