/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.weld.WeldCapability;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.processors.WeldDeploymentProcessor;
import org.jboss.as.weld.logging.WeldLogger;

public class EarApplicationScopedObserverMethodProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability api;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit)) {
            api.registerExtensionInstance((Extension)new PortableExtension(deploymentUnit), deploymentUnit);
        }
    }

    private static class PortableExtension
    implements Extension {
        private final DeploymentUnit deploymentUnit;

        private PortableExtension(DeploymentUnit deploymentUnit) {
            this.deploymentUnit = deploymentUnit;
        }

        public <Object, X> void processObserverMethod(@Observes ProcessObserverMethod<Object, X> event) {
            final ObserverMethod method = event.getObserverMethod();
            for (Annotation a : method.getObservedQualifiers()) {
                List<SetupAction> setupActions;
                DeploymentUnit beanDeploymentUnit;
                if (!(a instanceof Initialized && ((Initialized)a).value().equals(ApplicationScoped.class) || a instanceof BeforeDestroyed && ((BeforeDestroyed)a).value().equals(ApplicationScoped.class)) && (!(a instanceof Destroyed) || !((Destroyed)a).value().equals(ApplicationScoped.class)) || (beanDeploymentUnit = this.getBeanDeploymentUnit(method.getBeanClass().getName())) == null || (setupActions = WeldDeploymentProcessor.getSetupActions(beanDeploymentUnit)).isEmpty()) continue;
                event.setObserverMethod(new ObserverMethod<Object>(){

                    public Class<?> getBeanClass() {
                        return method.getBeanClass();
                    }

                    public Type getObservedType() {
                        return method.getObservedType();
                    }

                    public Set<Annotation> getObservedQualifiers() {
                        return method.getObservedQualifiers();
                    }

                    public Reception getReception() {
                        return method.getReception();
                    }

                    public TransactionPhase getTransactionPhase() {
                        return method.getTransactionPhase();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void notify(Object event) {
                        try {
                            for (SetupAction action : setupActions) {
                                action.setup(null);
                            }
                            method.notify(event);
                        }
                        finally {
                            for (SetupAction action : setupActions) {
                                try {
                                    action.teardown(null);
                                }
                                catch (Exception e) {
                                    WeldLogger.DEPLOYMENT_LOGGER.exceptionClearingThreadState(e);
                                }
                            }
                        }
                    }
                });
            }
        }

        private DeploymentUnit getBeanDeploymentUnit(String beanClass) {
            for (DeploymentUnit subDeploymentUnit : this.deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
                BeanDeploymentModule beanDeploymentModule = (BeanDeploymentModule)subDeploymentUnit.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
                if (beanDeploymentModule == null) continue;
                for (BeanDeploymentArchiveImpl beanDeploymentArchive : beanDeploymentModule.getBeanDeploymentArchives()) {
                    if (!beanDeploymentArchive.getBeanClasses().contains(beanClass)) continue;
                    return subDeploymentUnit;
                }
            }
            return null;
        }
    }
}

