/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.ResponseHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;

public class AttachmentHandler
extends BatchModeCommandHandler {
    private static final String DISPLAY = "display";
    private static final String SAVE = "save";
    private final FileSystemPathArgument targetFile;
    private final ArgumentWithoutValue createDirs;
    private final ArgumentWithValue operation;
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            if (buffer == null || buffer.isEmpty()) {
                candidates.add(AttachmentHandler.DISPLAY);
                candidates.add(AttachmentHandler.SAVE);
                return cursor;
            }
            if (buffer.equals(AttachmentHandler.DISPLAY) || buffer.equals(AttachmentHandler.SAVE)) {
                candidates.add(" ");
                return cursor;
            }
            if (AttachmentHandler.DISPLAY.startsWith(buffer)) {
                candidates.add("display ");
                return 0;
            }
            if (AttachmentHandler.SAVE.startsWith(buffer)) {
                candidates.add("save ");
                return 0;
            }
            return -1;
        }
    }, 0, "--action");
    private final ArgumentWithoutValue overwrite;

    public AttachmentHandler(CommandContext ctx) {
        super(ctx, "attachment", true);
        this.operation = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                char ch;
                String cmd;
                int cmdStart;
                int wordCount;
                boolean skipWS;
                String substitutedLine = ctx.getParsedCommandLine().getSubstitutedLine();
                if (Character.isWhitespace(substitutedLine.charAt(0))) {
                    skipWS = true;
                    wordCount = 0;
                } else {
                    skipWS = false;
                    wordCount = 1;
                }
                for (cmdStart = 1; cmdStart < substitutedLine.length(); ++cmdStart) {
                    if (skipWS) {
                        if (Character.isWhitespace(substitutedLine.charAt(cmdStart))) continue;
                        skipWS = false;
                        if (++wordCount != 3) continue;
                        break;
                    }
                    if (!Character.isWhitespace(substitutedLine.charAt(cmdStart))) continue;
                    skipWS = true;
                }
                if (wordCount == 1) {
                    cmd = "";
                } else {
                    if (wordCount != 3) {
                        return -1;
                    }
                    cmd = substitutedLine.substring(cmdStart);
                    int i = cmd.indexOf("=");
                    if (i > 0) {
                        cmd = i == cmd.length() - 1 ? "" : cmd.substring(i + 1);
                    }
                }
                int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, cmd.length(), candidates);
                if (cmdResult < 0) {
                    return cmdResult;
                }
                int escapeCorrection = 0;
                int start = substitutedLine.length() - 1 - buffer.length();
                while (start - escapeCorrection >= 0 && !Character.isWhitespace(ch = substitutedLine.charAt(start - escapeCorrection)) && ch != '=') {
                    ++escapeCorrection;
                }
                return buffer.length() + escapeCorrection - (cmd.length() - cmdResult);
            }
        }, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                String act = AttachmentHandler.this.getAction(ctx);
                if (!AttachmentHandler.SAVE.equals(act) && !AttachmentHandler.DISPLAY.equals(act)) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addRequiredPreceding(this.action);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.targetFile = new FileSystemPathArgument(this, pathCompleter, "--file"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!AttachmentHandler.SAVE.equals(AttachmentHandler.this.getAction(ctx))) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.targetFile.addRequiredPreceding(this.operation);
        this.createDirs = new ArgumentWithoutValue(this, "--createDirs"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!AttachmentHandler.SAVE.equals(AttachmentHandler.this.getAction(ctx))) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.overwrite = new ArgumentWithoutValue(this, "--overwrite"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!AttachmentHandler.SAVE.equals(AttachmentHandler.this.getAction(ctx))) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.headers.addRequiredPreceding(this.operation);
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        String act = this.getAction(ctx);
        if (DISPLAY.equals(act)) {
            if (this.targetFile.isPresent(ctx.getParsedCommandLine())) {
                throw new CommandFormatException(this.targetFile.getFullName() + " can't be used with display action");
            }
            if (this.overwrite.isPresent(ctx.getParsedCommandLine())) {
                throw new CommandFormatException(this.overwrite.getFullName() + " can't be used with display action");
            }
            if (this.createDirs.isPresent(ctx.getParsedCommandLine())) {
                throw new CommandFormatException(this.createDirs.getFullName() + " can't be used with display action");
            }
        }
        super.recognizeArguments(ctx);
    }

    private String getAction(CommandContext ctx) {
        String originalLine = ctx.getParsedCommandLine().getOriginalLine();
        if (originalLine == null || originalLine.isEmpty()) {
            return null;
        }
        String[] words = originalLine.trim().split(" ");
        String action = null;
        boolean seenFirst = false;
        for (String w : words) {
            if (w.isEmpty() || w.isEmpty()) continue;
            if (seenFirst) {
                action = w;
                break;
            }
            seenFirst = true;
        }
        return action;
    }

    @Override
    protected void handleResponse(CommandContext ctx, OperationResponse response, boolean composite) throws CommandLineException {
        ModelNode result = response.getResponseNode();
        String targetPath = this.targetFile.getValue(ctx.getParsedCommandLine());
        String act = this.action.getValue(ctx.getParsedCommandLine());
        if (act == null || act.isEmpty()) {
            throw new CommandFormatException("Action is missing");
        }
        AttachmentResponseHandler handler = new AttachmentResponseHandler(ctx, targetPath, act.equals(SAVE), this.overwrite.isPresent(ctx.getParsedCommandLine()), this.createDirs.isPresent(ctx.getParsedCommandLine()));
        handler.handleResponse(result, response);
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        String op = this.operation.getValue(ctx.getParsedCommandLine());
        if (op == null) {
            throw new CommandFormatException("Invalid operation");
        }
        ModelNode mn = ctx.buildRequest(op);
        return mn;
    }

    private static void retrieveStreams(ModelNode step, Set<String> uuids, Set<String> mystreams) {
        switch (step.getType()) {
            case STRING: {
                if (!uuids.contains(step.asString())) break;
                mystreams.add(step.asString());
                break;
            }
            case OBJECT: {
                for (String key : step.keys()) {
                    ModelNode mn = step.get(key);
                    AttachmentHandler.retrieveStreams(mn, uuids, mystreams);
                }
                break;
            }
            case LIST: {
                for (int i = 0; i < step.asInt(); ++i) {
                    ModelNode mn = step.get(i);
                    AttachmentHandler.retrieveStreams(mn, uuids, mystreams);
                }
                break;
            }
        }
    }

    private static Set<String> getStreams(ModelNode response) {
        ModelNode respHeaders;
        HashSet<String> ret = new HashSet<String>();
        if (response.hasDefined("response-headers") && (respHeaders = response.get("response-headers")).hasDefined("attached-streams")) {
            ModelNode attachments = respHeaders.get("attached-streams");
            for (int i = 0; i < attachments.asInt(); ++i) {
                ModelNode attachment = attachments.get(i);
                if (!attachment.hasDefined("uuid")) continue;
                ret.add(attachment.get("uuid").asString());
            }
        }
        return ret;
    }

    @Override
    public OperationCommand.HandledRequest buildHandledRequest(CommandContext ctx, Attachments attachments) throws CommandFormatException {
        String targetPath = this.targetFile.getValue(ctx.getParsedCommandLine());
        String act = this.action.getValue(ctx.getParsedCommandLine());
        if (act == null || act.isEmpty()) {
            throw new CommandFormatException("Action is missing");
        }
        AttachmentResponseHandler handler = new AttachmentResponseHandler(ctx, targetPath, act.equals(SAVE), this.overwrite.isPresent(ctx.getParsedCommandLine()), this.createDirs.isPresent(ctx.getParsedCommandLine()));
        return new OperationCommand.HandledRequest(this.buildRequest(ctx, attachments), handler);
    }

    private static class AttachmentResponseHandler
    implements ResponseHandler {
        private final boolean save;
        private final String targetPath;
        private final CommandContext ctx;
        private final boolean overwrite;
        private final boolean createDirs;

        private AttachmentResponseHandler(CommandContext ctx, String targetPath, boolean save, boolean overwrite, boolean createDirs) {
            this.ctx = ctx;
            this.targetPath = targetPath;
            this.save = save;
            this.overwrite = overwrite;
            this.createDirs = createDirs;
        }

        @Override
        public void handleResponse(ModelNode step, OperationResponse response) throws CommandLineException {
            Set<String> uuids = AttachmentHandler.getStreams(response.getResponseNode());
            if (uuids.isEmpty()) {
                return;
            }
            TreeSet<String> mystreams = new TreeSet<String>();
            AttachmentHandler.retrieveStreams(step, uuids, mystreams);
            int index = 0;
            for (String uuid : mystreams) {
                if (this.save) {
                    index = this.saveStream(uuid, response, index);
                    continue;
                }
                this.displayStream(uuid, response);
            }
        }

        private int saveStream(String uuid, OperationResponse response, int index) throws CommandLineException {
            Object target;
            Object object = target = this.targetPath == null ? uuid : this.targetPath;
            if (index > 0) {
                target = (String)target + "(" + index + ")";
            }
            OperationResponse.StreamEntry entry = response.getInputStream(uuid);
            File targetFile = new File((String)target);
            if (!this.overwrite) {
                while (targetFile.exists()) {
                    String name = targetFile.getName();
                    int indexed = name.lastIndexOf("(");
                    if (indexed > 0) {
                        try {
                            String num = name.substring(indexed + 1, name.length() - 1);
                            index = Integer.valueOf(num);
                            ++index;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        ++index;
                    }
                    targetFile = new File(targetFile.getAbsolutePath() + "(" + index + ")");
                }
            } else {
                ++index;
            }
            try {
                if (this.createDirs) {
                    Files.createDirectories(targetFile.toPath().getParent(), new FileAttribute[0]);
                }
                Files.copy(entry.getStream(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.ctx.printLine("File saved to " + targetFile.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new CommandLineException("Exception saving stream ", ex);
            }
            return index;
        }

        private void displayStream(String uuid, OperationResponse response) throws CommandLineException {
            OperationResponse.StreamEntry entry = response.getInputStream(uuid);
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int bytesRead;
                while ((bytesRead = entry.getStream().read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                this.ctx.printLine("ATTACHMENT " + uuid + ":");
                this.ctx.printLine(new String(out.toByteArray()));
            }
            catch (IOException ex) {
                throw new CommandLineException("Exception reading stream ", ex);
            }
        }
    }
}

