/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadStreamAttachmentHandler
extends AbstractDeploymentUploadHandler {
    public static final String OPERATION_NAME = "upload-deployment-stream";

    private DeploymentUploadStreamAttachmentHandler(ContentRepository repository) {
        super(repository, DeploymentAttributes.INPUT_STREAM_INDEX_NOT_NULL);
    }

    public static void registerMaster(ManagementResourceRegistration registration, ContentRepository repository) {
        new DeploymentUploadStreamAttachmentHandler(repository).register(registration);
    }

    public static void registerSlave(ManagementResourceRegistration registration) {
        new DeploymentUploadStreamAttachmentHandler(null).register(registration);
    }

    private void register(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(DeploymentAttributes.DOMAIN_UPLOAD_STREAM_ATTACHMENT_DEFINITION, (OperationStepHandler)this);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        int maxIndex;
        int streamIndex = operation.get("input-stream-index").asInt();
        if (streamIndex > (maxIndex = operationContext.getAttachmentStreamCount())) {
            throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.invalidValue("input-stream-index", streamIndex, maxIndex));
        }
        InputStream in = operationContext.getAttachmentStream(streamIndex);
        if (in == null) {
            throw new OperationFailedException(DomainControllerLogger.ROOT_LOGGER.nullStream(streamIndex));
        }
        return in;
    }
}

