/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.shallow;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.shallow.IgnoredAttributeProvider;
import org.wildfly.extension.messaging.activemq.shallow.OperationAddressConverter;

public class TranslatedReadAttributeHandler
implements OperationStepHandler {
    private final OperationAddressConverter converter;
    private final IgnoredAttributeProvider provider;

    public TranslatedReadAttributeHandler(OperationAddressConverter converter, IgnoredAttributeProvider provider) {
        this.converter = converter;
        this.provider = provider;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode op;
        String attribute;
        PathAddress targetAddress = this.converter.convert(context, operation);
        Set<String> ignoredAttributes = this.provider.getIgnoredAttributes(context, operation);
        if (ignoredAttributes.contains(attribute = (op = operation.clone()).require("name").asString())) {
            return;
        }
        op.get("address").set(targetAddress.toModelNode());
        OperationStepHandler readAttributeHandler = context.getRootResourceRegistration().getAttributeAccess(targetAddress, attribute).getReadHandler();
        if (readAttributeHandler == null) {
            readAttributeHandler = ReadAttributeHandler.INSTANCE;
        }
        context.addStep(op, readAttributeHandler, context.getCurrentStage(), true);
    }
}

