/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.marshalling.Pair;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BasicSerializableClassDescriptor;
import org.jboss.marshalling.river.ClassDescriptor;
import org.jboss.marshalling.river.Protocol;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.river.SimpleClassDescriptor;

final class ClassDescriptors {
    public static final ClassDescriptor STRING_DESCRIPTOR = new SimpleClassDescriptor(String.class, 20);
    public static final ClassDescriptor CLASS_DESCRIPTOR = new SimpleClassDescriptor(Class.class, 21);
    public static final ClassDescriptor OBJECT_DESCRIPTOR = new SimpleClassDescriptor(Object.class, 22);
    public static final ClassDescriptor ENUM_DESCRIPTOR = new SimpleClassDescriptor(Enum.class, 23);
    public static final ClassDescriptor BOOLEAN = new SimpleClassDescriptor(Boolean.TYPE, 32);
    public static final ClassDescriptor BYTE = new SimpleClassDescriptor(Byte.TYPE, 33);
    public static final ClassDescriptor SHORT = new SimpleClassDescriptor(Short.TYPE, 34);
    public static final ClassDescriptor INT = new SimpleClassDescriptor(Integer.TYPE, 35);
    public static final ClassDescriptor LONG = new SimpleClassDescriptor(Long.TYPE, 36);
    public static final ClassDescriptor CHAR = new SimpleClassDescriptor(Character.TYPE, 37);
    public static final ClassDescriptor FLOAT = new SimpleClassDescriptor(Float.TYPE, 38);
    public static final ClassDescriptor DOUBLE = new SimpleClassDescriptor(Double.TYPE, 39);
    public static final ClassDescriptor VOID = new SimpleClassDescriptor(Void.TYPE, 40);
    public static final ClassDescriptor BOOLEAN_OBJ = new SimpleClassDescriptor(Boolean.class, 41);
    public static final ClassDescriptor BYTE_OBJ = new SimpleClassDescriptor(Byte.class, 42);
    public static final ClassDescriptor SHORT_OBJ = new SimpleClassDescriptor(Short.class, 43);
    public static final ClassDescriptor INTEGER_OBJ = new SimpleClassDescriptor(Integer.class, 44);
    public static final ClassDescriptor LONG_OBJ = new SimpleClassDescriptor(Long.class, 45);
    public static final ClassDescriptor CHARACTER_OBJ = new SimpleClassDescriptor(Character.class, 46);
    public static final ClassDescriptor FLOAT_OBJ = new SimpleClassDescriptor(Float.class, 47);
    public static final ClassDescriptor DOUBLE_OBJ = new SimpleClassDescriptor(Double.class, 48);
    public static final ClassDescriptor VOID_OBJ = new SimpleClassDescriptor(Void.class, 49);
    public static final ClassDescriptor BOOLEAN_ARRAY = new SimpleClassDescriptor(boolean[].class, 24);
    public static final ClassDescriptor BYTE_ARRAY = new SimpleClassDescriptor(byte[].class, 25);
    public static final ClassDescriptor SHORT_ARRAY = new SimpleClassDescriptor(short[].class, 26);
    public static final ClassDescriptor INT_ARRAY = new SimpleClassDescriptor(int[].class, 27);
    public static final ClassDescriptor LONG_ARRAY = new SimpleClassDescriptor(long[].class, 28);
    public static final ClassDescriptor CHAR_ARRAY = new SimpleClassDescriptor(char[].class, 29);
    public static final ClassDescriptor FLOAT_ARRAY = new SimpleClassDescriptor(float[].class, 30);
    public static final ClassDescriptor DOUBLE_ARRAY = new SimpleClassDescriptor(double[].class, 31);
    public static final ClassDescriptor ABSTRACT_COLLECTION = new SimpleClassDescriptor(AbstractCollection.class, 109);
    public static final ClassDescriptor ABSTRACT_LIST = new SimpleClassDescriptor(AbstractList.class, 111);
    public static final ClassDescriptor ABSTRACT_QUEUE = new SimpleClassDescriptor(AbstractQueue.class, 112);
    public static final ClassDescriptor ABSTRACT_SEQUENTIAL_LIST = new SimpleClassDescriptor(AbstractSequentialList.class, 113);
    public static final ClassDescriptor ABSTRACT_SET = new SimpleClassDescriptor(AbstractSet.class, 110);
    public static final ClassDescriptor ABSTRACT_MAP = new SimpleClassDescriptor(AbstractMap.class, 7);
    public static final ClassDescriptor PAIR = new SimpleClassDescriptor(Pair.class, 119);
    static final ClassDescriptor SINGLETON_MAP = ClassDescriptors.getSerializableClassDescriptor(Protocol.singletonMapClass);
    static final ClassDescriptor SINGLETON_SET = ClassDescriptors.getSerializableClassDescriptor(Protocol.singletonSetClass);
    static final ClassDescriptor SINGLETON_LIST = ClassDescriptors.getSerializableClassDescriptor(Protocol.singletonListClass);
    static final ClassDescriptor EMPTY_MAP = ClassDescriptors.getSerializableClassDescriptor(Protocol.emptyMapClass);
    static final ClassDescriptor EMPTY_SET = ClassDescriptors.getSerializableClassDescriptor(Protocol.emptySetClass);
    static final ClassDescriptor EMPTY_LIST = ClassDescriptors.getSerializableClassDescriptor(Protocol.emptyListClass);
    static final ClassDescriptor CC_ARRAY_LIST = ClassDescriptors.getSerializableClassDescriptor(ArrayList.class, ABSTRACT_LIST);
    static final ClassDescriptor CC_LINKED_LIST = ClassDescriptors.getSerializableClassDescriptor(LinkedList.class, ABSTRACT_SEQUENTIAL_LIST);
    static final ClassDescriptor CC_HASH_SET = ClassDescriptors.getSerializableClassDescriptor(HashSet.class, ABSTRACT_SET);
    static final ClassDescriptor CC_LINKED_HASH_SET = ClassDescriptors.getSerializableClassDescriptor(LinkedHashSet.class, CC_HASH_SET);
    static final ClassDescriptor CC_TREE_SET = ClassDescriptors.getSerializableClassDescriptor(TreeSet.class, ABSTRACT_SET);
    static final ClassDescriptor CC_IDENTITY_HASH_MAP = ClassDescriptors.getSerializableClassDescriptor(IdentityHashMap.class, ABSTRACT_MAP);
    static final ClassDescriptor CC_HASH_MAP = ClassDescriptors.getSerializableClassDescriptor(HashMap.class, ABSTRACT_MAP);
    static final ClassDescriptor CC_HASHTABLE = ClassDescriptors.getSerializableClassDescriptor(Hashtable.class, new SimpleClassDescriptor(Dictionary.class, 7));
    static final ClassDescriptor CC_LINKED_HASH_MAP = ClassDescriptors.getSerializableClassDescriptor(LinkedHashMap.class, CC_HASH_MAP);
    static final ClassDescriptor CC_TREE_MAP = ClassDescriptors.getSerializableClassDescriptor(TreeMap.class, ABSTRACT_MAP);
    static final ClassDescriptor CC_ENUM_SET = ClassDescriptors.getSerializableClassDescriptor(EnumSet.class, ABSTRACT_SET);
    static final ClassDescriptor CC_ENUM_MAP = ClassDescriptors.getSerializableClassDescriptor(EnumMap.class, ABSTRACT_MAP);
    static final ClassDescriptor CONCURRENT_HASH_MAP = ClassDescriptors.getSerializableClassDescriptor(ConcurrentHashMap.class, ABSTRACT_MAP);
    static final ClassDescriptor COPY_ON_WRITE_ARRAY_LIST = ClassDescriptors.getSerializableClassDescriptor(CopyOnWriteArrayList.class, OBJECT_DESCRIPTOR);
    static final ClassDescriptor COPY_ON_WRITE_ARRAY_SET = ClassDescriptors.getSerializableClassDescriptor(CopyOnWriteArraySet.class, ABSTRACT_SET);
    static final ClassDescriptor VECTOR = ClassDescriptors.getSerializableClassDescriptor(Vector.class, ABSTRACT_LIST);
    static final ClassDescriptor STACK = ClassDescriptors.getSerializableClassDescriptor(Stack.class, VECTOR);
    static final ClassDescriptor ARRAY_DEQUE = ClassDescriptors.getSerializableClassDescriptor(ArrayDeque.class, ABSTRACT_COLLECTION);
    static final ClassDescriptor REVERSE_ORDER = ClassDescriptors.getSerializableClassDescriptor(Protocol.reverseOrderClass);
    static final ClassDescriptor REVERSE_ORDER2 = ClassDescriptors.getSerializableClassDescriptor(Protocol.reverseOrder2Class);
    static final ClassDescriptor NCOPIES = ClassDescriptors.getSerializableClassDescriptor(Protocol.nCopiesClass);
    static final ClassDescriptor UNMODIFIABLE_SET = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableSetClass);
    static final ClassDescriptor UNMODIFIABLE_COLLECTION = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableCollectionClass);
    static final ClassDescriptor UNMODIFIABLE_LIST = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableListClass);
    static final ClassDescriptor UNMODIFIABLE_MAP = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableMapClass);
    static final ClassDescriptor UNMODIFIABLE_SORTED_SET = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableSortedSetClass);
    static final ClassDescriptor UNMODIFIABLE_SORTED_MAP = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableSortedMapClass);
    static final ClassDescriptor UNMODIFIABLE_MAP_ENTRY_SET = ClassDescriptors.getSerializableClassDescriptor(Protocol.unmodifiableMapEntrySetClass);

    private ClassDescriptors() {
    }

    private static SerializableClassDescriptor getSerializableClassDescriptor(Class<?> subject) {
        return ClassDescriptors.getSerializableClassDescriptor(subject, null);
    }

    private static SerializableClassDescriptor getSerializableClassDescriptor(final Class<?> subject, final ClassDescriptor superDescriptor) {
        if (System.getSecurityManager() == null) {
            SerializableClassRegistry reg = SerializableClassRegistry.getInstance();
            SerializableClass serializableClass = reg.lookup(subject);
            SerializableField[] fields = serializableClass.getFields();
            boolean hasWriteObject = serializableClass.hasWriteObject();
            try {
                return new BasicSerializableClassDescriptor(serializableClass, superDescriptor, fields, Externalizable.class.isAssignableFrom(subject) ? 10 : (hasWriteObject ? 56 : 9));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<SerializableClassDescriptor>(){

            @Override
            public SerializableClassDescriptor run() {
                SerializableClassRegistry reg = SerializableClassRegistry.getInstance();
                SerializableClass serializableClass = reg.lookup(subject);
                SerializableField[] fields = serializableClass.getFields();
                boolean hasWriteObject = serializableClass.hasWriteObject();
                try {
                    return new BasicSerializableClassDescriptor(serializableClass, superDescriptor, fields, Externalizable.class.isAssignableFrom(subject) ? 10 : (hasWriteObject ? 56 : 9));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
            }
        });
    }
}

