/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Map;
import org.jboss.jca.common.CommonLogger;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.ds.DsXaPoolImpl;
import org.jboss.logging.Logger;

public class DsPoolImpl
extends PoolImpl
implements DsPool {
    private static final long serialVersionUID = 1L;
    protected Boolean allowMultipleUsers;
    protected Extension connectionListener;
    private static CommonLogger log = (CommonLogger)Logger.getMessageLogger(CommonLogger.class, (String)DsXaPoolImpl.class.getName());

    public DsPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean allowMultipleUsers, Capacity capacity, Boolean fair, Extension connectionListener) throws ValidateException {
        super(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, capacity, fair);
        this.allowMultipleUsers = allowMultipleUsers;
        this.connectionListener = connectionListener;
        this.checkAllowMultipleUsersPrefill();
    }

    public Boolean isAllowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    public Extension getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowMultipleUsers == null ? 0 : this.allowMultipleUsers.hashCode());
        result = 31 * result + (this.connectionListener == null ? 7 : 7 * this.connectionListener.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DsPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DsPoolImpl other = (DsPoolImpl)obj;
        if (this.allowMultipleUsers == null ? other.allowMultipleUsers != null : !this.allowMultipleUsers.equals(other.allowMultipleUsers)) {
            return false;
        }
        return !(this.connectionListener == null ? other.connectionListener != null : !this.connectionListener.equals((Object)other.connectionListener));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(DsPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(DsPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(DsPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(DsPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(DsPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(DsPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(DsPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(DsPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(DsPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(DsPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.fair != null && !this.fair.equals(Defaults.FAIR)) {
            sb.append("<").append(DsPool.Tag.FAIR).append(">");
            sb.append(this.fair);
            sb.append("</").append(DsPool.Tag.FAIR).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(DsPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(DsPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.allowMultipleUsers != null && this.allowMultipleUsers.booleanValue()) {
            sb.append("<").append(DsPool.Tag.ALLOW_MULTIPLE_USERS).append("/>");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        if (this.connectionListener != null) {
            sb.append("<").append(DsPool.Tag.CONNECTION_LISTENER);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.connectionListener.getClassName()).append("\"");
            sb.append(">");
            if (this.connectionListener.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.connectionListener.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(DsPool.Tag.CONNECTION_LISTENER).append(">");
        }
        sb.append("</pool>");
        return sb.toString();
    }

    private void checkAllowMultipleUsersPrefill() {
        if (this.allowMultipleUsers.booleanValue() && this.prefill.booleanValue()) {
            log.warnPrefillNotAllowedWithMultipleUsers();
        }
    }
}

