/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.BroadcastGroupControl;
import org.apache.activemq.artemis.core.management.impl.BaseBroadcastGroupControlImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.logs.AuditLogger;

public class BroadcastGroupControlImpl
extends BaseBroadcastGroupControlImpl
implements BroadcastGroupControl {
    private UDPBroadcastEndpointFactory endpointFactory;

    public BroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration, UDPBroadcastEndpointFactory endpointFactory) throws Exception {
        super(BroadcastGroupControl.class, broadcastGroup, storageManager, configuration);
        this.endpointFactory = endpointFactory;
    }

    public String getGroupAddress() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getGroupAddress((Object)this.getBroadcastGroup());
        }
        this.clearIO();
        try {
            String string = this.endpointFactory.getGroupAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getGroupPort() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getGroupPort((Object)this.getBroadcastGroup());
        }
        this.clearIO();
        try {
            int n = this.endpointFactory.getGroupPort();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getLocalBindPort() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getLocalBindPort((Object)this.getBroadcastGroup());
        }
        this.clearIO();
        try {
            int n = this.endpointFactory.getLocalBindPort();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }
}

