/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import org.apache.activemq.artemis.api.core.ActiveMQAlreadyReplicatingException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupTopologyListener;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.core.server.impl.quorum.ActivationSequenceStateMachine;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.jboss.logging.Logger;

public class ReplicationPrimaryActivation
extends LiveActivation
implements DistributedLock.UnavailableLockListener {
    private static final Logger LOGGER = Logger.getLogger(ReplicationPrimaryActivation.class);
    private static final long FAILBACK_TIMEOUT_MILLIS = 4000L;
    private final ReplicationPrimaryPolicy policy;
    private final ActiveMQServerImpl activeMQServer;
    @GuardedBy(value="replicationLock")
    private ReplicationManager replicationManager;
    private final Object replicationLock;
    private final DistributedPrimitiveManager distributedManager;
    private final AtomicBoolean stoppingServer;

    public ReplicationPrimaryActivation(ActiveMQServerImpl activeMQServer, DistributedPrimitiveManager distributedManager, ReplicationPrimaryPolicy policy) {
        this.activeMQServer = activeMQServer;
        this.policy = policy;
        this.replicationLock = new Object();
        this.distributedManager = distributedManager;
        this.stoppingServer = new AtomicBoolean();
    }

    public DistributedPrimitiveManager getDistributedManager() {
        return this.distributedManager;
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        ReplicationManager replicationManager = this.getReplicationManager();
        if (remotingService != null && replicationManager != null) {
            remotingService.freeze(null, replicationManager.getBackupTransportConnection());
        } else if (remotingService != null) {
            remotingService.freeze(null, null);
        }
    }

    @Override
    public void run() {
        try {
            DistributedLock liveLock;
            NodeManager nodeManager;
            if (this.policy.getCoordinationId() != null) {
                ReplicationPrimaryActivation.applyCoordinationId(this.policy.getCoordinationId(), this.activeMQServer);
            }
            if ((nodeManager = this.activeMQServer.getNodeManager()).getNodeActivationSequence() == -1L) {
                nodeManager.writeNodeActivationSequence(0L);
            }
            while (true) {
                this.distributedManager.start();
                try {
                    liveLock = ActivationSequenceStateMachine.tryActivate(nodeManager, this.distributedManager, LOGGER);
                }
                catch (UnavailableStateException canRecoverEx) {
                    this.distributedManager.stop();
                    continue;
                }
                break;
            }
            if (liveLock == null) {
                this.distributedManager.stop();
                LOGGER.infof("This broker cannot become a live server with NodeID = %s: restarting as backup", (Object)nodeManager.getNodeId());
                this.activeMQServer.setHAPolicy(this.policy.getBackupPolicy());
                return;
            }
            ActivationSequenceStateMachine.ensureSequentialAccessToNodeData(this.activeMQServer.toString(), nodeManager, this.distributedManager, LOGGER);
            this.activeMQServer.initialisePart1(false);
            this.activeMQServer.initialisePart2(false);
            liveLock.addListener((DistributedLock.UnavailableLockListener)this);
            if (!liveLock.isHeldByCaller()) {
                throw new IllegalStateException("This broker isn't live anymore, probably due to application pauses eg GC, OS etc: failing now");
            }
            this.activeMQServer.completeActivation(true);
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsLive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            this.distributedManager.stop();
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    public static void applyCoordinationId(String coordinationId, ActiveMQServerImpl activeMQServer) throws Exception {
        Objects.requireNonNull(coordinationId);
        if (!activeMQServer.getNodeManager().isStarted()) {
            throw new IllegalStateException("NodeManager should be started");
        }
        long activationSequence = activeMQServer.getNodeManager().getNodeActivationSequence();
        LOGGER.infof("Applying shared peer NodeID=%s to enable coordinated live activation", (Object)coordinationId);
        activeMQServer.resetNodeManager();
        NodeManager nodeManager = activeMQServer.getNodeManager();
        nodeManager.start();
        nodeManager.setNodeID(coordinationId);
        nodeManager.stopBackup();
        long freshActivationSequence = nodeManager.readNodeActivationSequence();
        assert (freshActivationSequence == activationSequence);
    }

    @Override
    public ChannelHandler getActivationChannelHandler(Channel channel, Acceptor acceptorUsed) {
        if (this.stoppingServer.get()) {
            return null;
        }
        return packet -> {
            if (packet.getType() == 115) {
                this.onBackupRegistration(channel, acceptorUsed, (BackupRegistrationMessage)packet);
            }
        };
    }

    private void onBackupRegistration(Channel channel, Acceptor acceptorUsed, BackupRegistrationMessage msg) {
        try {
            this.startAsyncReplication(channel.getConnection(), acceptorUsed.getClusterConnection(), msg.getConnector(), msg.isFailBackRequest());
        }
        catch (ActiveMQAlreadyReplicatingException are) {
            channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.ALREADY_REPLICATING));
        }
        catch (ActiveMQException e) {
            LOGGER.debug((Object)"Failed to process backup registration packet", (Throwable)e);
            channel.send((Packet)new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.EXCEPTION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsyncReplication(CoreRemotingConnection remotingConnection, ClusterConnection clusterConnection, TransportConfiguration backupTransport, boolean isFailBackRequest) throws ActiveMQException {
        Object object = this.replicationLock;
        synchronized (object) {
            ReplicationManager replicationManager;
            if (this.replicationManager != null) {
                throw new ActiveMQAlreadyReplicatingException();
            }
            if (!this.activeMQServer.isStarted()) {
                throw new ActiveMQIllegalStateException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            remotingConnection.addCloseListener((CloseListener)listener);
            remotingConnection.addFailureListener((FailureListener)listener);
            this.replicationManager = replicationManager = new ReplicationManager(this.activeMQServer, remotingConnection, clusterConnection.getCallTimeout(), this.policy.getInitialReplicationSyncTimeout(), this.activeMQServer.getIOExecutorFactory());
            replicationManager.start();
            Thread replicatingThread = new Thread(() -> this.replicate(replicationManager, clusterConnection, isFailBackRequest, backupTransport));
            replicatingThread.setName("async-replication-thread");
            replicatingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicate(ReplicationManager replicationManager, ClusterConnection clusterConnection, boolean isFailBackRequest, TransportConfiguration backupTransport) {
        try {
            String nodeID = this.activeMQServer.getNodeID().toString();
            this.activeMQServer.getStorageManager().startReplication(replicationManager, this.activeMQServer.getPagingManager(), nodeID, isFailBackRequest && this.policy.isAllowAutoFailBack(), this.policy.getInitialReplicationSyncTimeout());
            clusterConnection.nodeAnnounced(System.currentTimeMillis(), nodeID, this.policy.getGroupName(), this.policy.getScaleDownGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)new Pair(null, (Object)backupTransport), true);
            if (isFailBackRequest && this.policy.isAllowAutoFailBack()) {
                this.awaitBackupAnnouncementOnFailbackRequest(clusterConnection);
            }
        }
        catch (Exception e) {
            if (this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STARTED) {
                ActiveMQServerLogger.LOGGER.errorStartingReplication(e);
            }
            try {
                ActiveMQServerImpl.stopComponent(replicationManager);
            }
            catch (Exception amqe) {
                ActiveMQServerLogger.LOGGER.errorStoppingReplication(amqe);
            }
            finally {
                Object object = this.replicationLock;
                synchronized (object) {
                    if (this.replicationManager == replicationManager) {
                        this.replicationManager = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitBackupAnnouncementOnFailbackRequest(ClusterConnection clusterConnection) throws Exception {
        String nodeID = this.activeMQServer.getNodeID().toString();
        BackupTopologyListener topologyListener = new BackupTopologyListener(nodeID, clusterConnection.getConnector());
        clusterConnection.addClusterTopologyListener(topologyListener);
        try {
            if (topologyListener.waitForBackup()) {
                this.restartAsBackupAfterFailback();
            } else {
                ActiveMQServerLogger.LOGGER.failbackMissedBackupAnnouncement();
            }
        }
        finally {
            clusterConnection.removeClusterTopologyListener(topologyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartAsBackupAfterFailback() throws Exception {
        long inSyncReplicaActivation;
        String coordinatedLockAndNodeId;
        if (this.stoppingServer.get()) {
            return;
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.stoppingServer.get()) {
                return;
            }
            ReplicationManager replicationManager = this.replicationManager;
            if (replicationManager == null) {
                LOGGER.warnf("Failback interrupted", new Object[0]);
                return;
            }
            if (!this.stoppingServer.compareAndSet(false, true)) {
                LOGGER.infof("Failback interrupted: server is already stopping", new Object[0]);
                return;
            }
            coordinatedLockAndNodeId = this.activeMQServer.getNodeManager().getNodeId().toString();
            inSyncReplicaActivation = this.activeMQServer.getNodeManager().getNodeActivationSequence();
            this.activeMQServer.fail(true);
        }
        try {
            this.distributedManager.start();
            if (!ActivationSequenceStateMachine.awaitNextCommittedActivationSequence(this.distributedManager, coordinatedLockAndNodeId, inSyncReplicaActivation, 4000L, LOGGER)) {
                LOGGER.warnf("Timed out waiting for failback server activation with NodeID = %s: and sequence > %d: after %dms", (Object)coordinatedLockAndNodeId, (Object)inSyncReplicaActivation, (Object)4000L);
            }
        }
        catch (UnavailableStateException ignored) {
            LOGGER.debug((Object)"Unavailable distributed manager while awaiting failback activation sequence: ignored", (Throwable)ignored);
        }
        finally {
            this.distributedManager.stop();
        }
        ActiveMQServerLogger.LOGGER.restartingReplicatedBackupAfterFailback();
        this.activeMQServer.setHAPolicy(this.policy.getBackupPolicy());
        this.activeMQServer.start();
    }

    private void asyncStopServer() {
        if (this.stoppingServer.get()) {
            return;
        }
        if (this.stoppingServer.compareAndSet(false, true)) {
            new Thread(() -> {
                try {
                    this.activeMQServer.stop();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRestartingBackupServer(e, this.activeMQServer);
                }
            }).start();
        }
    }

    public void onUnavailableLockEvent() {
        LOGGER.error((Object)"Quorum UNAVAILABLE: async stopping broker.");
        this.asyncStopServer();
    }

    private void onReplicationConnectionClose() {
        ExecutorService executorService = this.activeMQServer.getThreadPool();
        if (executorService != null) {
            if (this.stoppingServer.get()) {
                return;
            }
            executorService.execute(() -> {
                Object object = this.replicationLock;
                synchronized (object) {
                    StorageManager storageManager;
                    if (this.replicationManager == null) {
                        return;
                    }
                    if (!this.stoppingServer.get() && ActiveMQServer.SERVER_STATE.STARTED.equals((Object)this.activeMQServer.getState())) {
                        try {
                            ActivationSequenceStateMachine.ensureSequentialAccessToNodeData(this.activeMQServer.toString(), this.activeMQServer.getNodeManager(), this.distributedManager, LOGGER);
                        }
                        catch (Throwable fatal) {
                            LOGGER.errorf(fatal, "Unexpected exception: %s on attempted activation sequence increment; stopping server async", (Object)fatal.getLocalizedMessage());
                            this.asyncStopServer();
                        }
                    }
                    if ((storageManager = this.activeMQServer.getStorageManager()) != null) {
                        storageManager.stopReplication();
                    }
                    this.replicationManager = null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        Object object = this.replicationLock;
        synchronized (object) {
            this.replicationManager = null;
        }
        this.distributedManager.stop();
        NodeManager nodeManager = this.activeMQServer.getNodeManager();
        if (nodeManager != null) {
            if (permanently) {
                nodeManager.crashLiveServer();
            } else {
                nodeManager.pauseLiveServer();
            }
        }
    }

    @Override
    public void sendLiveIsStopping() {
        ReplicationManager replicationManager = this.getReplicationManager();
        if (replicationManager == null) {
            return;
        }
        replicationManager.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED);
        this.activeMQServer.getScheduledPool().schedule(replicationManager::clearReplicationTokens, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager getReplicationManager() {
        Object object = this.replicationLock;
        synchronized (object) {
            return this.replicationManager;
        }
    }

    @Override
    public boolean isReplicaSync() {
        ReplicationManager replicationManager = this.getReplicationManager();
        if (replicationManager == null) {
            return false;
        }
        return !replicationManager.isSynchronizing();
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            ReplicationPrimaryActivation.this.onReplicationConnectionClose();
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void connectionClosed() {
            ReplicationPrimaryActivation.this.onReplicationConnectionClose();
        }
    }
}

