/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.jboss.logging.Logger;

final class JdbcLeaseLock
implements LeaseLock {
    private static final Logger LOGGER = Logger.getLogger(JdbcLeaseLock.class);
    private static final int MAX_HOLDER_ID_LENGTH = 128;
    private final JDBCConnectionProvider connectionProvider;
    private final String holderId;
    private final String tryAcquireLock;
    private final String tryReleaseLock;
    private final String renewLock;
    private final String isLocked;
    private final String currentDateTime;
    private final TimeZone currentDateTimeTimeZone;
    private final long expirationMillis;
    private final int queryTimeout;
    private boolean maybeAcquired;
    private final String lockName;
    private long localExpirationTime;

    JdbcLeaseLock(String holderId, JDBCConnectionProvider connectionProvider, String tryAcquireLock, String tryReleaseLock, String renewLock, String isLocked, String currentDateTime, String currentDateTimeTimeZoneId, long expirationMIllis, long queryTimeoutMillis, String lockName) {
        if (holderId.length() > 128) {
            throw new IllegalArgumentException("holderId length must be <=128");
        }
        this.holderId = holderId;
        this.tryAcquireLock = tryAcquireLock;
        this.tryReleaseLock = tryReleaseLock;
        this.renewLock = renewLock;
        this.isLocked = isLocked;
        this.currentDateTime = currentDateTime;
        this.currentDateTimeTimeZone = currentDateTimeTimeZoneId == null ? null : TimeZone.getTimeZone(currentDateTimeTimeZoneId);
        this.expirationMillis = expirationMIllis;
        this.maybeAcquired = false;
        this.connectionProvider = connectionProvider;
        this.lockName = lockName;
        this.localExpirationTime = -1L;
        int expectedTimeout = -1;
        if (queryTimeoutMillis >= 0L && (expectedTimeout = (int)TimeUnit.MILLISECONDS.toSeconds(queryTimeoutMillis)) <= 0) {
            LOGGER.warn((Object)"queryTimeoutMillis is too low: it's suggested to configure a multi-seconds value. Disabling it because too low.");
            expectedTimeout = -1;
        }
        this.queryTimeout = expectedTimeout;
    }

    public String holderId() {
        return this.holderId;
    }

    @Override
    public long localExpirationTime() {
        return this.localExpirationTime;
    }

    @Override
    public long expirationMillis() {
        return this.expirationMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private String readableLockStatus() {
        try (Connection connection = this.connectionProvider.getConnection();){
            String string;
            PreparedStatement preparedStatement;
            boolean autoCommit;
            block30: {
                String lockStatus;
                connection.setTransactionIsolation(2);
                autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                preparedStatement = connection.prepareStatement(this.isLocked);
                long currentTimestamp = this.dbCurrentTimeMillis(connection);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) {
                        lockStatus = null;
                    } else {
                        String currentHolderId = resultSet.getString(1);
                        long expirationTime = resultSet.getLong(2);
                        lockStatus = "holderId = " + currentHolderId + " expirationTime = " + expirationTime + " currentTimestamp = " + currentTimestamp;
                    }
                }
                connection.commit();
                string = lockStatus;
                if (preparedStatement == null) break block30;
                preparedStatement.close();
            }
            connection.setAutoCommit(autoCommit);
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException ie) {
                            connection.rollback();
                            String string2 = ie.getMessage();
                            connection.setAutoCommit(autoCommit);
                            if (connection != null) {
                                connection.close();
                            }
                            return string2;
                        }
                    }
                    catch (Throwable throwable3) {
                        connection.setAutoCommit(autoCommit);
                        throw throwable3;
                    }
                }
            }
        }
        catch (SQLException e) {
            return e.getMessage();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public long dbCurrentTimeMillis() {
        SQLException suppressed = null;
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setTransactionIsolation(2);
            boolean autoCommit2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try {
                long l = this.dbCurrentTimeMillis(connection);
                return l;
            }
            catch (SQLException e) {
                suppressed = e;
                connection.rollback();
                suppressed = null;
                throw new IllegalStateException(e);
            }
            finally {
                connection.setAutoCommit(autoCommit2);
            }
            {
                catch (Throwable autoCommit2) {
                    throw autoCommit2;
                }
            }
        }
        catch (SQLException e) {
            IllegalStateException stateEx = new IllegalStateException(e);
            if (suppressed != null) {
                stateEx.addSuppressed(suppressed);
            }
            throw stateEx;
        }
    }

    private long dbCurrentTimeMillis(Connection connection) throws SQLException {
        return JdbcLeaseLock.dbCurrentTimeMillis(connection, this.queryTimeout, this.currentDateTime, this.currentDateTimeTimeZone);
    }

    public static long dbCurrentTimeMillis(Connection connection, int queryTimeout, String currentDateTimeSql, TimeZone currentDateTimeTimeZone) throws SQLException {
        try (PreparedStatement currentDateTime = connection.prepareStatement(currentDateTimeSql);){
            long l;
            block15: {
                if (queryTimeout >= 0) {
                    currentDateTime.setQueryTimeout(queryTimeout);
                }
                long startTime = JdbcLeaseLock.stripMilliseconds(System.currentTimeMillis());
                ResultSet resultSet = currentDateTime.executeQuery();
                try {
                    resultSet.next();
                    long endTime = JdbcLeaseLock.stripMilliseconds(System.currentTimeMillis());
                    long currentTime = (currentDateTimeTimeZone == null ? resultSet.getTimestamp(1) : resultSet.getTimestamp(1, Calendar.getInstance(currentDateTimeTimeZone))).getTime();
                    long currentTimeNoMillis = JdbcLeaseLock.stripMilliseconds(currentTime);
                    if (currentTimeNoMillis < startTime) {
                        LOGGER.warnf("currentTimestamp = %d on database should happen AFTER %d on broker", (Object)currentTimeNoMillis, (Object)startTime);
                    }
                    if (currentTimeNoMillis > endTime) {
                        LOGGER.warnf("currentTimestamp = %d on database should happen BEFORE %d on broker", (Object)currentTimeNoMillis, (Object)endTime);
                    }
                    l = currentTime;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean renew() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long stripMilliseconds(long time) {
        return time / 1000L * 1000L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean tryAcquire() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isHeld() {
        return this.checkValidHolderId(Objects::nonNull);
    }

    @Override
    public boolean isHeldByCaller() {
        return this.checkValidHolderId(this.holderId::equals);
    }

    /*
     * Exception decompiling
     */
    private boolean checkValidHolderId(Predicate<? super String> holderIdFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void release() {
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setTransactionIsolation(2);
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.tryReleaseLock);){
                preparedStatement.setString(1, this.holderId);
                boolean released = preparedStatement.executeUpdate() == 1;
                this.localExpirationTime = -1L;
                this.maybeAcquired = false;
                connection.commit();
                if (!released) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debugf("[%s] %s has failed to release lock: lock status = { %s }", (Object)this.lockName, (Object)this.holderId, (Object)this.readableLockStatus());
                    }
                } else {
                    LOGGER.debugf("[%s] %s has released lock", (Object)this.lockName, (Object)this.holderId);
                }
            }
            catch (SQLException ie) {
                connection.rollback();
                throw new IllegalStateException(ie);
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.maybeAcquired) {
            this.release();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

