/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=2, max=4), @ValidIdRange(min=5151, max=5151), @ValidIdRange(min=8013, max=8028)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=2, value="Parameter %s is empty")
    public IllegalArgumentException emptyParameter(String var1);

    @Message(id=4, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @Message(id=5151, value="Invalid OTP algorithm \"%s\"")
    public SaslException mechInvalidOTPAlgorithm(String var1);

    @Message(id=8013, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8014, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8015, value="Cannot verify password")
    public InvalidKeyException invalidKeyCannotVerifyPassword(@Cause Throwable var1);

    @Message(id=8017, value="DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8018, value="Salt must be %d bytes (%d bits)")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int var1, int var2);

    @Message(id=8020, value="Invalid number of rounds. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int var1, int var2);

    @Message(id=8021, value="Invalid salt: must be %d bytes long")
    public IllegalArgumentException invalidSaltMustBeBytesLong(int var1);

    @Message(id=8022, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8023, value="Salt must be %d bytes")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int var1);

    @Message(id=8024, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8025, value="Expected to get a \"%s\" as spec, got \"%s\"")
    public InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String var1, String var2);

    @Message(id=8026, value="Unknown algorithm \"%s\" or incompatible PasswordSpec \"%s\"")
    public InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec(String var1, String var2);

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();

    @Message(id=8028, value="Invalid algorithm \"%s\"")
    public NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String var1);
}

