/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.jboss.vfs.VirtualFile;

public final class Utils {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public static final String LINE_SEP = String.format("%n", new Object[0]);
    public static final char WIN_SEP = '\\';
    public static final char SYS_SEP = File.separatorChar;
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;

    public static void safeClose(JarFile jf) {
        try {
            if (jf != null) {
                jf.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void safelyClose(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<String> readLines(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        ArrayList<String> result = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            result.add(line);
            line = reader.readLine();
        }
        return result;
    }

    public static String toString(VirtualFile r) throws IOException {
        return new String(Utils.toBytes(r), StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(VirtualFile r) throws IOException {
        try (InputStream is = r.openStream();){
            byte[] byArray = Utils.toByteArray(is);
            return byArray;
        }
    }

    static byte[] toByteArray(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int bytesRead = is.read(buffer);
            while (bytesRead > -1) {
                os.write(buffer, 0, bytesRead);
                bytesRead = is.read(buffer);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static void skip(InputStream is, long amount) throws IOException {
        long amountSkipped = 0L;
        for (long leftToSkip = amount; leftToSkip > 0L && amountSkipped >= 0L; leftToSkip -= amountSkipped) {
            amountSkipped = is.skip(leftToSkip);
        }
    }

    public static boolean isSymlink(VirtualFile vFile) throws IOException {
        File file = vFile.getPhysicalFile();
        if (Utils.isWindows()) {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static boolean isWindows() {
        return SYS_SEP == '\\';
    }
}

