/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jgroups.util.SocketFactory;

public class ManagedSocketFactory
implements SocketFactory {
    private final SocketBindingManager manager;
    private final Map<String, SocketBinding> socketBindings;

    public ManagedSocketFactory(SocketBindingManager manager, Map<String, SocketBinding> socketBindings) {
        this.manager = manager;
        this.socketBindings = socketBindings;
    }

    private String getSocketBindingName(String name) {
        SocketBinding socketBinding = this.socketBindings.get(name);
        return socketBinding != null ? socketBinding.getName() : name;
    }

    public Socket createSocket(String name) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getSocketFactory().createSocket(socketBindingName);
    }

    public Socket createSocket(String name, String host, int port) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getSocketFactory().createSocket(socketBindingName, host, port);
    }

    public Socket createSocket(String name, InetAddress address, int port) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getSocketFactory().createSocket(socketBindingName, address, port);
    }

    public Socket createSocket(String name, String host, int port, InetAddress localHost, int localPort) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getSocketFactory().createSocket(socketBindingName, host, port, localHost, localPort);
    }

    public Socket createSocket(String name, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getSocketFactory().createSocket(socketBindingName, address, port, localAddress, localPort);
    }

    public ServerSocket createServerSocket(String name) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getServerSocketFactory().createServerSocket(socketBindingName);
    }

    public ServerSocket createServerSocket(String name, int port) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getServerSocketFactory().createServerSocket(socketBindingName, port);
    }

    public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getServerSocketFactory().createServerSocket(socketBindingName, port, backlog);
    }

    public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress ifAddress) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.getServerSocketFactory().createServerSocket(socketBindingName, port, backlog, ifAddress);
    }

    public DatagramSocket createDatagramSocket(String name) throws SocketException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.createDatagramSocket(socketBindingName);
    }

    public DatagramSocket createDatagramSocket(String name, SocketAddress address) throws SocketException {
        if (address == null) {
            return this.createDatagramSocket(name);
        }
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.createDatagramSocket(socketBindingName, address);
    }

    public DatagramSocket createDatagramSocket(String name, int port) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(port));
    }

    public DatagramSocket createDatagramSocket(String name, int port, InetAddress address) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(address, port));
    }

    public MulticastSocket createMulticastSocket(String name) throws IOException {
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.createMulticastSocket(socketBindingName);
    }

    public MulticastSocket createMulticastSocket(String name, int port) throws IOException {
        return this.createMulticastSocket(name, new InetSocketAddress(port));
    }

    public MulticastSocket createMulticastSocket(String name, SocketAddress address) throws IOException {
        if (address == null) {
            return this.createMulticastSocket(name);
        }
        String socketBindingName = this.getSocketBindingName(name);
        return this.manager.createMulticastSocket(socketBindingName, address);
    }

    public SocketChannel createSocketChannel(String name) throws IOException {
        SocketChannel channel = SocketChannel.open();
        this.manager.getNamedRegistry().registerChannel(name, channel);
        return channel;
    }

    public ServerSocketChannel createServerSocketChannel(String name) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        this.manager.getNamedRegistry().registerChannel(name, channel);
        return channel;
    }

    public void close(Socket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public void close(ServerSocket socket) throws IOException {
        if (socket != null) {
            socket.close();
        }
    }

    public void close(DatagramSocket socket) {
        if (socket != null) {
            socket.close();
        }
    }

    public Map<Object, String> getSockets() {
        throw new UnsupportedOperationException();
    }
}

