/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.UndertowSessionAttributeImmutability;
import org.wildfly.clustering.web.undertow.session.UndertowSpecificationProvider;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;
import org.wildfly.common.iteration.CompositeIterable;

public class SessionManagerFactoryConfigurationAdapter<C extends DistributableSessionManagementConfiguration<DeploymentUnit>>
extends WebDeploymentConfigurationAdapter
implements SessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, Map<String, Object>> {
    private final Integer maxActiveSessions;
    private final ByteBufferMarshaller marshaller;
    private final Immutability immutability;
    private final SessionAttributePersistenceStrategy attributePersistenceStrategy;

    public SessionManagerFactoryConfigurationAdapter(org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration configuration, C managementConfiguration, Immutability immutability) {
        super((WebDeploymentConfiguration)configuration);
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        this.marshaller = (ByteBufferMarshaller)managementConfiguration.getMarshallerFactory().apply(configuration.getDeploymentUnit());
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        this.immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(UndertowSessionAttributeImmutability.class), loadedImmutability, Collections.singleton(immutability)}));
        this.attributePersistenceStrategy = managementConfiguration.getAttributePersistenceStrategy();
    }

    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public ByteBufferMarshaller getMarshaller() {
        return this.marshaller;
    }

    public LocalContextFactory<Map<String, Object>> getLocalContextFactory() {
        return LocalSessionContextFactory.INSTANCE;
    }

    public Immutability getImmutability() {
        return this.immutability;
    }

    public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
        return UndertowSpecificationProvider.INSTANCE;
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.attributePersistenceStrategy;
    }
}

