/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.undertow.server.HttpHandler;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIHttpHandler;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIServiceNameProvider;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.Host;

public class OpenAPIHttpHandlerServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
Service {
    private final SupplierDependency<OpenAPI> model;
    private final SupplierDependency<Host> host;
    private final String path;

    public OpenAPIHttpHandlerServiceConfigurator(OpenAPIServiceNameProvider provider) {
        super(provider.getServiceName().append(new String[]{"handler"}));
        this.model = new ServiceSupplierDependency(provider.getServiceName());
        this.host = new ServiceSupplierDependency(provider.getHostServiceName());
        this.path = provider.getPath();
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        new CompositeDependency(new Dependency[]{this.model, this.host}).register(builder);
        return builder.setInstance((Service)this);
    }

    public void start(StartContext context) {
        Host host = (Host)this.host.get();
        host.registerHandler(this.path, (HttpHandler)new OpenAPIHttpHandler((OpenAPI)this.model.get()));
        MicroProfileOpenAPILogger.LOGGER.endpointRegistered(this.path, host.getName());
    }

    public void stop(StopContext context) {
        Host host = (Host)this.host.get();
        host.unregisterHandler(this.path);
        MicroProfileOpenAPILogger.LOGGER.endpointUnregistered(this.path, host.getName());
    }
}

