/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

final class SecurityActions {
    private SecurityActions() {
    }

    static Method getAnnotationMethod(Class<?> clazz, String name) throws PrivilegedActionException, NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getMethod(name, new Class[0]);
        }
        return AccessController.doPrivileged(() -> clazz.getMethod(name, new Class[0]));
    }

    static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException, PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredField(name);
        }
        return AccessController.doPrivileged(() -> clazz.getDeclaredField(name));
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            accessibleObject.setAccessible(true);
        }
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    static Method getDeclaredMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] parameterTypes) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return SecurityActions.doGetMethod(beanClass, declaringClass, name, parameterTypes);
        }
        return AccessController.doPrivileged(() -> SecurityActions.doGetMethod(beanClass, declaringClass, name, parameterTypes));
    }

    private static Method doGetMethod(Class<?> beanClass, Class<?> declaringClass, String name, Type[] expectedParameters) {
        Method method;
        Class<?> current = beanClass;
        ParametrizedParamsTranslator expectedParamsTranslator = SecurityActions.prepareParamsTranslator(beanClass, declaringClass);
        ParametrizedParamsTranslator actualParamsTranslator = new ParametrizedParamsTranslator();
        HashSet<String> allInterfaceMethodNames = new HashSet<String>();
        for (Class<?> clazz : declaringClass.getInterfaces()) {
            for (Method m : clazz.getMethods()) {
                allInterfaceMethodNames.add(m.getName());
            }
        }
        while (true) {
            if ((method = SecurityActions.getMethodFromClass(beanClass, current, name, expectedParameters, actualParamsTranslator, expectedParamsTranslator)) != null && (current.isAssignableFrom(declaringClass) || allInterfaceMethodNames.contains(method.getName()))) {
                return method;
            }
            if (current.getSuperclass() == null) break;
            actualParamsTranslator = actualParamsTranslator.getSuperclassTranslator(current);
            current = current.getSuperclass();
        }
        for (Class<?> anInterface : beanClass.getInterfaces()) {
            method = SecurityActions.getMethodFromClass(beanClass, anInterface, name, expectedParameters, actualParamsTranslator, expectedParamsTranslator);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static ParametrizedParamsTranslator prepareParamsTranslator(Class<?> beanClass, Class<?> clazz) {
        ParametrizedParamsTranslator result = new ParametrizedParamsTranslator();
        if (beanClass == clazz) {
            return result;
        }
        for (Class<?> current = beanClass; current != clazz && current != null && current.getSuperclass() != null; current = current.getSuperclass()) {
            result = result.getSuperclassTranslator(current);
        }
        return result;
    }

    private static List<Type> incomingTypesForSuperclass(Class<?> current, List<Type> typeParameters, List<Type> incomingTypes) {
        Type genericSuperclass = current.getGenericSuperclass();
        List<Type> actualTypeParams = genericSuperclass instanceof ParameterizedType ? Arrays.asList(((ParameterizedType)genericSuperclass).getActualTypeArguments()) : Collections.emptyList();
        ArrayList<Type> result = new ArrayList<Type>(actualTypeParams.size());
        for (Type type : actualTypeParams) {
            if (type instanceof Class) {
                result.add(type);
                continue;
            }
            int paramIdx = typeParameters.indexOf(type);
            result.add(paramIdx >= 0 ? incomingTypes.get(paramIdx) : type);
        }
        return result;
    }

    private static Method getMethodFromClass(Class<?> originatingClass, Class<?> clazz, String name, Type[] parameterTypes, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        Optional<? super Method> maybeMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> SecurityActions.isAccessibleFrom(method, originatingClass)).filter(method -> method.getName().equals(name)).filter(SecurityActions.parametersMatch(parameterTypes, translator, expectedParamsTranslator)).findAny();
        return maybeMethod.orElse(null);
    }

    private static boolean isAccessibleFrom(Method method, Class<?> originatingClass) {
        if (SecurityActions.isAccessible(method, 1) || SecurityActions.isAccessible(method, 4)) {
            return true;
        }
        if (SecurityActions.isAccessible(method, 2)) {
            return method.getDeclaringClass() == originatingClass;
        }
        return method.getDeclaringClass().getPackage() == originatingClass.getPackage();
    }

    private static boolean isAccessible(Method method, int accessLevel) {
        return (method.getModifiers() & accessLevel) != 0;
    }

    private static Predicate<? super Method> parametersMatch(Type[] parameterTypes, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        return method -> {
            Type[] methodParams = method.getGenericParameterTypes();
            if (parameterTypes.length != methodParams.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (SecurityActions.parameterMatches(methodParams[i], parameterTypes[i], translator, expectedParamsTranslator)) continue;
                return false;
            }
            return true;
        };
    }

    private static boolean parameterMatches(Type methodParam, Type parameterType, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        methodParam = translator.translate(methodParam);
        parameterType = expectedParamsTranslator.translate(parameterType);
        if (methodParam instanceof Class) {
            return parameterType == methodParam;
        }
        if (SecurityActions.isArray(parameterType)) {
            if (SecurityActions.isArray(methodParam)) {
                Type methodParamComponentType = SecurityActions.getArrayComponentType(methodParam);
                Type componentType = SecurityActions.getArrayComponentType(parameterType);
                return SecurityActions.parameterMatches(methodParamComponentType, componentType, translator, expectedParamsTranslator);
            }
            return false;
        }
        if (methodParam instanceof ParameterizedType) {
            if (parameterType instanceof ParameterizedType) {
                return SecurityActions.parameterizedTypeMatches((ParameterizedType)methodParam, (ParameterizedType)parameterType, translator, expectedParamsTranslator);
            }
            return false;
        }
        if (methodParam instanceof WildcardType) {
            if (parameterType instanceof WildcardType) {
                return SecurityActions.wildcardTypeMatches((WildcardType)methodParam, (WildcardType)parameterType, translator, expectedParamsTranslator);
            }
            return false;
        }
        return false;
    }

    private static boolean wildcardTypeMatches(WildcardType methodParam, WildcardType parameterType, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        boolean lowerBoundsMatch = SecurityActions.typeArrayMatches(methodParam.getLowerBounds(), parameterType.getLowerBounds(), translator, expectedParamsTranslator);
        boolean upperBoundsMatch = SecurityActions.typeArrayMatches(methodParam.getUpperBounds(), parameterType.getUpperBounds(), translator, expectedParamsTranslator);
        return lowerBoundsMatch && upperBoundsMatch;
    }

    private static boolean typeArrayMatches(Type[] methodTypes, Type[] paramTypes, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        if (methodTypes.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < methodTypes.length; ++i) {
            if (SecurityActions.parameterMatches(methodTypes[i], paramTypes[i], translator, expectedParamsTranslator)) continue;
            return false;
        }
        return true;
    }

    private static boolean parameterizedTypeMatches(ParameterizedType methodParam, ParameterizedType parameterType, ParametrizedParamsTranslator translator, ParametrizedParamsTranslator expectedParamsTranslator) {
        Type[] actualParameters;
        Type[] methodParameters = methodParam.getActualTypeArguments();
        if (methodParameters.length != (actualParameters = parameterType.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < methodParameters.length; ++i) {
            if (SecurityActions.parameterMatches(methodParameters[i], actualParameters[i], translator, expectedParamsTranslator)) continue;
            return false;
        }
        return true;
    }

    private static Type getArrayComponentType(Type parameterType) {
        if (parameterType instanceof Class) {
            return ((Class)parameterType).getComponentType();
        }
        return ((GenericArrayType)parameterType).getGenericComponentType();
    }

    private static boolean isArray(Type parameterType) {
        if (parameterType instanceof Class) {
            return ((Class)parameterType).isArray();
        }
        return parameterType instanceof GenericArrayType;
    }

    static Method[] getDeclaredMethods(Class<?> clazz) throws PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        return AccessController.doPrivileged(clazz::getDeclaredMethods);
    }

    private static class ParametrizedParamsTranslator {
        private final List<Type> incomingTypes = new ArrayList<Type>();
        private final List<Type> typeParameters = new ArrayList<Type>();

        private ParametrizedParamsTranslator() {
        }

        Type translate(Type paramType) {
            int typeIdx = this.typeParameters.indexOf(paramType);
            if (typeIdx >= 0) {
                paramType = this.incomingTypes.get(typeIdx);
            }
            return paramType;
        }

        ParametrizedParamsTranslator getSuperclassTranslator(Class<?> current) {
            ParametrizedParamsTranslator result = new ParametrizedParamsTranslator();
            result.incomingTypes.addAll(SecurityActions.incomingTypesForSuperclass(current, this.typeParameters, this.incomingTypes));
            result.typeParameters.addAll(Arrays.asList(current.getSuperclass().getTypeParameters()));
            return result;
        }
    }
}

