/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jaxrs.JaxrsServerConfig;
import org.jboss.as.jaxrs.JaxrsServerConfigService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

final class JaxrsParamHandler
extends AbstractWriteAttributeHandler<Void> {
    public JaxrsParamHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        if (!this.isSameValue(context, resolvedValue, currentValue, attributeName)) {
            this.updateServerConfig(context, attributeName, resolvedValue, false);
        }
        return false;
    }

    private boolean isSameValue(OperationContext context, ModelNode resolvedValue, ModelNode currentValue, String attributeName) throws OperationFailedException {
        if (resolvedValue.equals(this.getAttributeDefinition(attributeName).resolveValue(context, currentValue))) {
            return true;
        }
        if (!currentValue.isDefined()) {
            return resolvedValue.equals(this.getAttributeDefinition(attributeName).getDefaultValue());
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        this.updateServerConfig(null, attributeName, valueToRestore, true);
    }

    private void updateServerConfig(OperationContext context, String attributeName, ModelNode value, boolean isRevert) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceName name = JaxrsServerConfigService.CONFIG_SERVICE;
        JaxrsServerConfig config = (JaxrsServerConfig)registry.getRequiredService(name).getValue();
        if ("jaxrs-2-0-request-matching".equals(attributeName)) {
            config.setJaxrs20RequestMatching(value);
        } else if ("resteasy-add-charset".equals(attributeName)) {
            config.setResteasyAddCharset(value);
        } else if ("resteasy-buffer-exception-entity".equals(attributeName)) {
            config.setResteasyBufferExceptionEntity(value);
        } else if ("resteasy-disable-html-sanitizer".equals(attributeName)) {
            config.setResteasyDisableHtmlSanitizer(value);
        } else if ("resteasy-disable-providers".equals(attributeName)) {
            config.setResteasyDisableProviders(value);
        } else if ("resteasy-document-expand-entity-references".equals(attributeName)) {
            config.setResteasyDocumentExpandEntityReferences(value);
        } else if ("resteasy-document-secure-disableDTDs".equals(attributeName)) {
            config.setResteasySecureDisableDTDs(value);
        } else if ("resteasy-document-secure-processing-feature".equals(attributeName)) {
            config.setResteasyDocumentSecureProcessingFeature(value);
        } else if ("resteasy-gzip-max-input".equals(attributeName)) {
            config.setResteasyGzipMaxInput(value);
        } else if ("resteasy-jndi-resources".equals(attributeName)) {
            config.setResteasyJndiResources(value);
        } else if ("resteasy-language-mappings".equals(attributeName)) {
            config.setResteasyLanguageMappings(value);
        } else if ("resteasy-media-type-mappings".equals(attributeName)) {
            config.setResteasyMediaTypeMappings(value);
        } else if ("resteasy-media-type-param-mapping".equals(attributeName)) {
            config.setResteasyMediaTypeParamMapping(value);
        } else if ("resteasy-prefer-jackson-over-jsonb".equals(attributeName)) {
            config.setResteasyPreferJacksonOverJsonB(value);
        } else if ("resteasy-providers".equals(attributeName)) {
            config.setResteasyProviders(value);
        } else if ("resteasy-rfc7232preconditions".equals(attributeName)) {
            config.setResteasyRFC7232Preconditions(value);
        } else if ("resteasy-role-based-security".equals(attributeName)) {
            config.setResteasyRoleBasedSecurity(value);
        } else if ("resteasy-secure-random-max-use".equals(attributeName)) {
            config.setResteasySecureRandomMaxUse(value);
        } else if ("resteasy-use-builtin-providers".equals(attributeName)) {
            config.setResteasyUseBuiltinProviders(value);
        } else if ("resteasy-use-container-form-params".equals(attributeName)) {
            config.setResteasyUseContainerFormParams(value);
        } else if ("resteasy-wider-request-matching".equals(attributeName)) {
            config.setResteasyWiderRequestMatching(value);
        }
    }
}

