/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.registry;

import java.util.List;
import org.jboss.as.clustering.controller.BinaryServiceNameFactory;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.common.iteration.CompositeIterable;
import org.wildfly.extension.clustering.server.IdentityCacheRequirementServiceConfiguratorProvider;

public class IdentityRegistryFactoryServiceConfiguratorProvider
extends IdentityCacheRequirementServiceConfiguratorProvider {
    public IdentityRegistryFactoryServiceConfiguratorProvider() {
        super(ClusteringCacheRequirement.REGISTRY_FACTORY);
    }

    public Iterable<ServiceConfigurator> getServiceConfigurators(OperationContext context, String containerName, String cacheName, String targetCacheName) {
        Iterable configurators = super.getServiceConfigurators(context, containerName, cacheName, targetCacheName);
        ServiceName registryServiceName = ClusteringCacheRequirement.REGISTRY.getServiceName(context, containerName, cacheName);
        ServiceName registryEntryServiceName = ClusteringCacheRequirement.REGISTRY_ENTRY.getServiceName(context, containerName, cacheName);
        ServiceConfigurator registryConfigurator = new IdentityCapabilityServiceConfigurator(registryServiceName, (BinaryServiceNameFactory)ClusteringCacheRequirement.REGISTRY, containerName, targetCacheName).configure(context);
        ServiceConfigurator registryEntryConfigurator = new IdentityCapabilityServiceConfigurator(registryEntryServiceName, (BinaryServiceNameFactory)ClusteringCacheRequirement.REGISTRY_ENTRY, containerName, targetCacheName).configure(context);
        return new CompositeIterable(new Iterable[]{configurators, List.of(registryConfigurator, registryEntryConfigurator)});
    }
}

