/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class CommaDelimiterRfc2253Name {
    public String execute(String rfc2253String) {
        StringBuilder commaDNBuilder = new StringBuilder();
        try {
            LdapName ldapname = new LdapName(rfc2253String);
            List<Rdn> rdns = ldapname.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rdn = rdns.get(i);
                String rdnString = rdn.toString();
                String appendString = this.requiresDoubleQuoting(rdnString) ? this.convertToDoubleQuotes(rdnString) : rdnString;
                if (i == rdns.size() - 1) {
                    commaDNBuilder.append(appendString);
                    continue;
                }
                commaDNBuilder.append(", ").append(appendString);
            }
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(" The distinguished name cannot be parsed : " + rfc2253String);
        }
        return commaDNBuilder.toString();
    }

    private boolean requiresDoubleQuoting(String rdnString) {
        return rdnString.contains("\\");
    }

    private String convertToDoubleQuotes(String rdnString) {
        StringBuilder quotedString = new StringBuilder();
        int indexEquals = rdnString.indexOf("=");
        String firstPart = rdnString.substring(0, indexEquals + 1);
        String lastPart = rdnString.substring(indexEquals + 1);
        String secondPart = this.unEscapeRfc2253RdnSubPart(lastPart);
        return quotedString.append(firstPart).append('\"').append(secondPart).append('\"').toString();
    }

    String unEscapeRfc2253RdnSubPart(String value) {
        char[] charArray = value.toCharArray();
        boolean previousEscape = false;
        StringBuilder unescapedRdnPart = new StringBuilder();
        for (char currentChar : charArray) {
            if (currentChar != '\\') {
                previousEscape = false;
                unescapedRdnPart.append(currentChar);
                continue;
            }
            if (previousEscape) {
                unescapedRdnPart.append(currentChar);
                previousEscape = false;
                continue;
            }
            previousEscape = true;
        }
        return unescapedRdnPart.toString();
    }
}

