/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.services.path.AbsolutePathService;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ee.subsystem.GlobalDirectoryResourceDefinition;
import org.jboss.modules.PathUtils;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.Assert;

public class GlobalDirectoryService
implements Service {
    private final Supplier<PathManager> pathManagerSupplier;
    private final String path;
    private final String relativeTo;
    private final PathResolver pathResolver;
    private final Consumer<GlobalDirectoryResourceDefinition.GlobalDirectory> consumer;
    private final String name;

    public GlobalDirectoryService(Supplier<PathManager> pathManagerSupplier, Consumer<GlobalDirectoryResourceDefinition.GlobalDirectory> consumer, String name, String path, String relativeTo) {
        this.pathManagerSupplier = (Supplier)Assert.checkNotNullParam((String)"pathManagerSupplier", pathManagerSupplier);
        this.path = (String)Assert.checkNotNullParam((String)"path", (Object)path);
        this.name = (String)Assert.checkNotNullParam((String)"name", (Object)name);
        this.relativeTo = relativeTo;
        this.pathResolver = new PathResolver();
        this.consumer = consumer;
    }

    public void start(StartContext context) throws StartException {
        this.pathResolver.path(this.path);
        this.pathResolver.relativeTo(this.relativeTo, this.pathManagerSupplier.get());
        GlobalDirectoryResourceDefinition.GlobalDirectory globaldirectory = new GlobalDirectoryResourceDefinition.GlobalDirectory(this.pathResolver.resolve(), this.name);
        this.consumer.accept(globaldirectory);
    }

    public void stop(StopContext context) {
        this.pathResolver.clear();
    }

    private static class PathResolver {
        private String path;
        private String relativeTo;
        private PathManager pathManager;
        private PathManager.Callback.Handle callbackHandle;

        private PathResolver() {
        }

        PathResolver path(String path) {
            this.path = path;
            return this;
        }

        PathResolver relativeTo(String relativeTo, PathManager pathManager) {
            this.relativeTo = relativeTo;
            this.pathManager = pathManager;
            return this;
        }

        Path resolve() {
            String relativeToPath = AbsolutePathService.isAbsoluteUnixOrWindowsPath((String)this.path) ? null : this.relativeTo;
            Path resolvedPath = Paths.get(PathUtils.canonicalize((String)this.pathManager.resolveRelativePathEntry(this.path, relativeToPath)), new String[0]).normalize();
            if (this.relativeTo != null) {
                this.callbackHandle = this.pathManager.registerCallback(this.relativeTo, new PathManager.Callback(){

                    public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                        if (!eventContext.isResourceServiceRestartAllowed()) {
                            eventContext.reloadRequired();
                        }
                    }

                    public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                    }
                }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
            }
            return resolvedPath;
        }

        void clear() {
            if (this.callbackHandle != null) {
                this.callbackHandle.remove();
                this.callbackHandle = null;
            }
        }
    }
}

