/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.patching.Constants;
import org.jboss.as.patching.installation.Identity;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.installation.SecurityActions;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.validation.PatchingFileRenamingCollector;
import org.jboss.as.patching.validation.PatchingGarbageLocator;
import org.jboss.as.version.ProductConfig;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class InstallationManagerService
implements Service<InstallationManager> {
    public static ServiceName NAME = Constants.JBOSS_PATCHING.append(new String[]{"manager"});
    private static final String MODULE_PATH = "module.path";
    private static final String BUNDLES_DIR = "jboss.bundles.dir";
    private volatile InstallationManager manager;
    private final InjectedValue<ProductConfig> productConfig = new InjectedValue();

    public static ServiceController<InstallationManager> installService(ServiceTarget serviceTarget) {
        InstallationManagerService service = new InstallationManagerService();
        return serviceTarget.addService(NAME, (Service)service).addDependency(Constants.JBOSS_PRODUCT_CONFIG_SERVICE, ProductConfig.class, service.productConfig).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private InstallationManagerService() {
    }

    public synchronized void start(StartContext startContext) throws StartException {
        try {
            File renamingMaker;
            File jbossHome = new File(SecurityActions.getSystemProperty("jboss.home.dir"));
            ProductConfig productConfig = (ProductConfig)this.productConfig.getValue();
            this.manager = InstallationManagerService.load(jbossHome, productConfig);
            File cleanupMaker = new File(this.manager.getInstalledImage().getInstallationMetadata(), "cleanup-patching-dirs");
            boolean cleanup = cleanupMaker.exists();
            for (InstalledIdentity installedIdentity : this.manager.getInstalledIdentities()) {
                Identity identity = installedIdentity.getIdentity();
                PatchableTarget.TargetInfo patchingInfo = identity.loadTargetInfo();
                StringBuilder buf = new StringBuilder();
                for (String id : patchingInfo.getPatchIDs()) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(id);
                }
                if (buf.length() == 0) {
                    buf.append("none");
                }
                PatchLogger.ROOT_LOGGER.logPatchingInfo(identity.getName(), patchingInfo.getCumulativePatchID(), buf.toString());
                if (!cleanup) continue;
                try {
                    PatchingGarbageLocator garbageLocator = PatchingGarbageLocator.getIninitialized(installedIdentity);
                    garbageLocator.deleteInactiveContent();
                }
                catch (Exception e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to garbage collect changes", new Object[0]);
                    cleanup = false;
                }
            }
            if (cleanup) {
                cleanupMaker.delete();
            }
            if ((renamingMaker = new File(this.manager.getInstalledImage().getInstallationMetadata(), "cleanup-renaming-files")).exists()) {
                try {
                    PatchingFileRenamingCollector renaming = new PatchingFileRenamingCollector(renamingMaker);
                    renaming.renameFiles();
                }
                catch (Exception e) {
                    PatchLogger.ROOT_LOGGER.debugf(e, "failed to rename files", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        this.manager = null;
    }

    public InstallationManager getValue() throws IllegalStateException, IllegalArgumentException {
        InstallationManager manager = this.manager;
        if (manager == null) {
            throw new IllegalStateException();
        }
        return manager;
    }

    protected static InstallationManager load(File jbossHome, ProductConfig productConfig) throws IOException {
        InstalledImage installedImage = InstalledIdentity.installedImage(jbossHome);
        List<File> moduleRoots = InstallationManagerService.getModulePath(installedImage);
        List<File> bundlesRoots = InstallationManagerService.getBundlePath(installedImage);
        return InstallationManager.load(jbossHome, moduleRoots, bundlesRoots, productConfig);
    }

    private static List<File> getModulePath(InstalledImage image) {
        LinkedHashSet<File> path = new LinkedHashSet<File>();
        String modulePath = SecurityActions.getSystemProperty(MODULE_PATH, SecurityActions.getEnv("JAVA_MODULEPATH"));
        if (modulePath != null) {
            String[] paths;
            for (String s : paths = modulePath.split(Pattern.quote(File.pathSeparator))) {
                File file = new File(s);
                path.add(file);
            }
        } else {
            path.add(image.getModulesDir());
        }
        return new ArrayList<File>(path);
    }

    private static List<File> getBundlePath(InstalledImage image) {
        String prop = SecurityActions.getSystemProperty(BUNDLES_DIR);
        File bundleRoots = prop != null ? new File(prop) : image.getBundlesDir();
        return Collections.singletonList(bundleRoots);
    }
}

