/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.patching.runner.PatchUtils;

public class LayersConfig {
    private final boolean configured;
    private final String layersPath;
    private final String addOnsPath;
    private final List<String> layers;

    LayersConfig() {
        this.configured = false;
        this.layersPath = "system/layers";
        this.addOnsPath = "system/add-ons";
        this.layers = Collections.singletonList("base");
    }

    LayersConfig(Properties properties) {
        this.configured = true;
        this.layersPath = properties.getProperty("layers.path", "system/layers");
        this.addOnsPath = properties.getProperty("add-ons.path", "system/add-ons");
        boolean excludeBase = Boolean.parseBoolean(properties.getProperty("exclude.base.layer", "false"));
        String layersProp = (String)properties.get("layers");
        if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
            this.layers = excludeBase ? Collections.emptyList() : Collections.singletonList("base");
        } else {
            String[] layerNames = layersProp.split(",");
            ArrayList<String> layers = new ArrayList<String>();
            boolean hasBase = false;
            for (String layerName : layerNames) {
                if ("base".equals(layerName)) {
                    hasBase = true;
                }
                layers.add(layerName);
            }
            if (!hasBase && !excludeBase) {
                layers.add("base");
            }
            this.layers = Collections.unmodifiableList(layers);
        }
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public String getLayersPath() {
        return this.layersPath;
    }

    public String getAddOnsPath() {
        return this.addOnsPath;
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public static LayersConfig getLayersConfig(File repoRoot) throws IOException {
        File layersList = new File(repoRoot, "layers.conf");
        if (!layersList.exists()) {
            return new LayersConfig();
        }
        Properties properties = PatchUtils.loadProperties(layersList);
        return new LayersConfig(properties);
    }
}

