/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.LongConsumer;

public class MultiOnRequestInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final LongConsumer consumer;

    public MultiOnRequestInvoke(Multi<? extends T> upstream, LongConsumer consumer) {
        super(upstream);
        this.consumer = consumer;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnRequestInvokeOperator(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnRequestInvokeOperator
    extends MultiOperatorProcessor<T, T> {
        public MultiOnRequestInvokeOperator(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void request(long numberOfItems) {
            try {
                MultiOnRequestInvoke.this.consumer.accept(numberOfItems);
                super.request(numberOfItems);
            }
            catch (Throwable err) {
                super.onFailure(err);
            }
        }
    }
}

