/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;

public class MultiOnTerminationCall<T>
extends AbstractMultiOperator<T, T> {
    private final BiFunction<Throwable, Boolean, Uni<?>> mapper;

    public MultiOnTerminationCall(Multi<? extends T> upstream, BiFunction<Throwable, Boolean, Uni<?>> mapper) {
        super(upstream);
        this.mapper = mapper;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnTerminationCallProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnTerminationCallProcessor
    extends MultiOperatorProcessor<T, T> {
        private volatile Cancellable cancellable;
        private final AtomicBoolean mapperInvoked;

        public MultiOnTerminationCallProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.mapperInvoked = new AtomicBoolean();
        }

        @Override
        public void cancel() {
            if (this.cancellable != null) {
                this.cancellable.cancel();
                super.cancel();
            } else {
                this.execute(null, true).subscribe().with(ignored -> super.cancel(), ignored -> {
                    Infrastructure.handleDroppedException(ignored);
                    super.cancel();
                });
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.cancellable = this.execute(failure, false).subscribe().with(ignored -> super.onFailure(failure), err -> super.onFailure(new CompositeException(failure, (Throwable)err)));
        }

        @Override
        public void onCompletion() {
            this.cancellable = this.execute(null, false).subscribe().with(ignored -> super.onCompletion(), x$0 -> super.onFailure((Throwable)x$0));
        }

        private Uni<?> execute(Throwable err, Boolean cancelled) {
            if (this.mapperInvoked.compareAndSet(false, true)) {
                try {
                    return Objects.requireNonNull((Uni)MultiOnTerminationCall.this.mapper.apply(err, cancelled), "Uni should not be null");
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
            return Uni.createFrom().nullItem();
        }
    }
}

